#ifndef LOGINDBDLG_H
#define LOGINDBDLG_H

#include <QtGui/QDialog>
#include "qxtxmlrpcclient.h"
#include "registerdlg.h"

namespace Ui {
    class LoginDbDlg;
}

class LoginDbDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(LoginDbDlg)
public:
    //! Constructor.
    explicit LoginDbDlg(QWidget *parent = 0);
    //! Destructor.
    virtual ~LoginDbDlg();

private:
    Ui::LoginDbDlg *m_ui;
    RegisterDlg *regDlg;
    //! Used for PHP calls.
    QxtXmlRpcClient *client;
    //! Id used with client.
    int loginId;
    //! Passwords hash value.
    QString *hashpwd;

private slots:
    //! Trys to login database.
    void on_okPushButton_clicked();
    //! Opens register dialog.
    void on_registerPushButton_clicked();
    //! Slots for clients return value.
    void processReturnValue(int Id,QVariant data);
    void error(int i,QString string);
    void fault(int i,int j,QString string);
    //! Enable and disable OK button.
    void allowOkButton();

signals:
    //! Emitted if login succesful.
    void loginReady(QString username,QString pwd);
};
#endif // LOGINDBDLG_H
