#ifndef BACKGROUNDCOLORDLG_H
#define BACKGROUNDCOLORDLG_H

#include <QtGui/QDialog>

namespace Ui {
    class BackgroundColorDlg;
}

class BackgroundColorDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(BackgroundColorDlg)
public:
    //! Constructor.
    explicit BackgroundColorDlg(QWidget *parent = 0, QColor color = Qt::black);
    //! Destructor.
    virtual ~BackgroundColorDlg();
	
	
	private:
    Ui::BackgroundColorDlg *m_ui;
 	QString red, green, blue;
    QPixmap pm;

private slots:
    //! Slot for setting label pixmap.
    void setPreviewPalette();
    //! Slot for emitting signals.
    void on_selectColorButton_clicked();

signals:
    //! When select clicked, emits backgroundcolor to BackgroundDialog class.
    void selectClicked(QColor bgc);
    //! When select clicked, emits backgroundcolor RGB values to BackgroundDialog class.
    void rgbValues(QString red,QString green,QString blue);
};
#endif // BACKGROUNDCOLORDLG_H
