#include "backgrounddlg.h"
#include "ui_backgrounddlg.h"

BackgroundDlg::BackgroundDlg(QWidget *parent, const QString &currentRemoteName) :
    QDialog(parent),
    m_ui(new Ui::BackgroundDlg),
    defaultImageSelected(true),
    redString("0"),
    greenString("0"),
    blueString("0")
{
    m_ui->setupUi(this);
    m_ui->okButton->setDisabled(true);

    remoteName = currentRemoteName;

    bgMode = defaultBackground;

    pm = QPixmap(120,80);
    backgroundColor = (QColor(Qt::black));
    pm.fill(backgroundColor);

    QIcon colorDlgButtonIcon = QIcon(pm);
    m_ui->colorButton->setIconSize(QSize(25,25));
    m_ui->colorButton->setIcon(colorDlgButtonIcon);
    m_ui->background->setAutoFillBackground(false);
    m_ui->background->setPixmap(QPixmap(qtirrecoImage));
    m_ui->background->setScaledContents(true);
    m_ui->background->setAlignment(Qt::AlignLeading|Qt::AlignLeft|Qt::AlignTop);
    backgroundPixmap = QPixmap(qtirrecoImage).scaled(800,424,Qt::IgnoreAspectRatio,Qt::FastTransformation);
    loadThemes();

    connect(m_ui->tabWidget,SIGNAL(currentChanged(int)),this,SLOT(activateTab(int)));
    connect(m_ui->listWidget,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(setBackgroundsOnListWidget2()));
    connect(m_ui->listWidget_2,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(setBackgroundOnPreviewLabel()));
}

BackgroundDlg::~BackgroundDlg()
{
    delete m_ui;
}



void BackgroundDlg::on_okButton_clicked()
{
    emit backgroundChanged(bgMode);
    this->close();
}

QPixmap BackgroundDlg::returnBackgroundPixmap()
{
    return backgroundPixmap;
}

QPixmap BackgroundDlg::returnBackgroundPixmapColor()
{
    return pm;
}

bool BackgroundDlg::isDefaultImageSelected()
{
    return defaultImageSelected;
}

void BackgroundDlg::setBackgroundColor(const QColor &bgc)
{
    backgroundColor = bgc;
}

void BackgroundDlg::rgbFromColorDlg(const QString &red,const QString &green,const QString &blue)
{
    redString = red;
    greenString = green;
    blueString = blue;
}

void BackgroundDlg::on_defaultImageButton_clicked()
{
    bgMode = defaultBackground;
    defaultImageSelected = true;
    m_ui->background->clear();
    m_ui->background->setAutoFillBackground(false);
    m_ui->defaultImageButton->setChecked(true);
    m_ui->background->setPixmap(QPixmap(qtirrecoImage));
    backgroundPixmap = QPixmap(qtirrecoImage);
}

void BackgroundDlg::on_colorButton_clicked()
{
    QPalette palette;

    bool ok;
    QColor color(redString.toInt(&ok,10),greenString.toInt(&ok,10),blueString.toInt(&ok,10));

    colorDlg = new BackgroundColorDlg(this, color);
    connect(colorDlg,SIGNAL(selectClicked(QColor)),this,SLOT(setBackgroundColor(QColor)));
    connect(colorDlg,SIGNAL(rgbValues(QString,QString,QString)),this,SLOT(rgbFromColorDlg(QString,QString,QString)));
    colorDlg->exec();

    pm.fill(backgroundColor);
    QIcon colorDlgButtonIcon = QIcon(pm);
    m_ui->colorButton->setIcon(colorDlgButtonIcon);

    bgMode = backgroundFromColor;
    defaultImageSelected = false;
    m_ui->background->clear();
    m_ui->colorButton->setChecked(true);
    m_ui->background->setAutoFillBackground(true);
    palette.setBrush(QPalette::Window, pm);
    m_ui->background->setPalette(palette);
    backgroundPixmap = pm;
    emit rgbToLw(redString, greenString, blueString);

}

QString BackgroundDlg::returnBackgroundImagePath()
{
    return backgroundImagePath;
}

void BackgroundDlg::on_imageButton_clicked()
{
    QString fileName = QFileDialog::getOpenFileName(this, tr("Open Image"), themesPath, tr("Image Files (*.png *.jpg *.bmp *.jpeg)"));
    QTextStream inputStream(&fileName);
    while (!inputStream.atEnd()) {
         inputStream >> bgImagePath;
         if (!bgImagePath.isEmpty()) {
              defaultImageSelected = false;
              QPixmap pix(bgImagePath);

              m_ui->background->setPixmap(pix);
              backgroundPixmap = pix.scaled(800,424,Qt::IgnoreAspectRatio,Qt::FastTransformation);
         }
    }
    backgroundImagePath = bgImagePath;
    bgMode = backgroundFromImage;
    defaultImageSelected = false;
}

void BackgroundDlg::activateTab(const int tabIndex)
{
    if(tabIndex == 0) {
        m_ui->listWidget_2->clear();
        m_ui->previewLabel->clear();
        m_ui->okButton->setDisabled(true);
    }
    else if (tabIndex == 1) {
        bool colorOnly = false;
        bgMode = defaultBackground;
        defaultImageSelected = true;
        m_ui->background->clear();
        m_ui->background->setAutoFillBackground(false);
        m_ui->defaultImageButton->setChecked(true);
        m_ui->background->setPixmap(QPixmap(qtirrecoImage));
        m_ui->okButton->setEnabled(true);
        backgroundPixmap = QPixmap(qtirrecoImage);

        // Check if remote uses color as background, if so set button icon color.
        QFile remote(remotesPath + remoteName + ".conf");
        if (!remote.open(QIODevice::ReadWrite | QIODevice::Text))
            return;
        QTextStream in(&remote);
        while (!in.atEnd()) {
            QString line = in.readLine();
            if(line.contains(("Color:"),Qt::CaseInsensitive)) {
                QString str[3];

                line = line.trimmed();
                line.remove(0,7);
                int lineLength = line.length();
                int index = 0;
                for(int i=0;i<lineLength;i++) {
                    if(line.at(i).isSpace() == false)
                        str[index].append(line.at(i));

                    if(line.at(i).isSpace() == true && index <=2)
                        index++;

                }
                redString = str[0];
                greenString = str[1];
                blueString = str[2];
                colorOnly = true;
            }
        }
        remote.close();

        // Set icon and palette color, set color_only property.
        if(colorOnly) {
            bool ok;
            pm = QPixmap(120,80);
            pm.fill(QColor(redString.toInt(&ok,10),greenString.toInt(&ok,10),blueString.toInt(&ok,10)));

            QIcon colorDlgButtonIcon = QIcon(pm);
            m_ui->colorButton->setIconSize(QSize(25,25));
            m_ui->colorButton->setIcon(colorDlgButtonIcon);

            backgroundColor = QColor(redString.toInt(&ok,10),greenString.toInt(&ok,10),blueString.toInt(&ok,10));

            QPalette palette;
            bgMode = backgroundFromColor;
            defaultImageSelected = false;
            m_ui->background->clear();
            m_ui->colorButton->setChecked(true);
            m_ui->background->setAutoFillBackground(true);
            palette.setBrush(QPalette::Window, pm);
            m_ui->background->setPalette(palette);
            backgroundPixmap = pm;
            emit rgbToLw(redString, greenString, blueString);
        }



    }
}

void BackgroundDlg::loadThemes()
{
    themeDirs = QDir(themesPath);

    themeDirList = themeDirs.entryList(QDir::NoDotAndDotDot | QDir::Dirs, QDir::Name);

    for(int i = 0 ; i < themeDirList.count() ; i++) {

        QString themeConf = themesPath + themeDirList.at(i) + "/theme.conf";
        // Check if theme has any background directories.
        QDir themeBgDirs(themesPath + themeDirList.at(i) + "/bg/");
        QStringList themeBgs = themeBgDirs.entryList(QDir::NoDotAndDotDot | QDir::Dirs, QDir::Name);
        if(!themeBgs.isEmpty()) {
            QFile file(themeConf);
            if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
                 QMessageBox::warning(this,"Error with theme config","Couldn't load " + themeDirList.at(i) + " theme config file!" +
                                 " Please download theme again from theme manager.",
                                 QMessageBox::NoButton,QMessageBox::NoButton);
                themeDirList.removeAt(i);
                i--;
            }
            else {
                QTextStream in(&file);
                while (!in.atEnd()) {
                    QString line = in.readLine();
                    process_line(line, THEME);
                }

               

                new QListWidgetItem(themeName,m_ui->listWidget);
                m_ui->listWidget->show();
            }
 		}
        else {
                themeDirList.removeAt(i);
                i--;
        }
    }
}
void BackgroundDlg::setBackgroundsOnListWidget2()
{
    m_ui->okButton->setDisabled(true);
    m_ui->backgroundPreview->clear();
    m_ui->listWidget_2->clear();

    currentIndex = m_ui->listWidget->currentRow();
    QDir backgroundDirs(themesPath + themeDirList.at(currentIndex) +"/bg/");
    backgroundList = backgroundDirs.entryList(QDir::NoDotAndDotDot | QDir::Dirs, QDir::Name);

    for(int i = 0 ; i < backgroundList.count() ; i++) {

        QString bgConf = themesPath + themeDirList.at(currentIndex) + "/bg/" + backgroundList.at(i) +"/bg.conf";
        QFile file(bgConf);
        if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
            QMessageBox::warning(this,"Error with background config","Failed to load background name from config",
                     QMessageBox::NoButton,QMessageBox::NoButton);
            return;
        }
        QTextStream in(&file);
        while (!in.atEnd()) {
            QString line = in.readLine();
            process_line(line, BACKGROUND);
        }


        new QListWidgetItem(backgroundName,m_ui->listWidget_2);
        m_ui->listWidget_2->show();
    }
}

void BackgroundDlg::setBackgroundOnPreviewLabel()
{
    bgMode = backgroundFromTheme;
    defaultImageSelected = false;

    QPixmap bgPreview(128,128);
    QString string(themesPath + themeDirList.at(currentIndex) +"/bg/"  + backgroundList.at(m_ui->listWidget_2->currentRow()) +"/image.png");
    bgPreview.load(string);
    backgroundImagePath = string;
    bgPreview = bgPreview.scaled(321,151,Qt::KeepAspectRatio,Qt::FastTransformation);
    m_ui->backgroundPreview->setPixmap(bgPreview);
    backgroundPixmap = bgPreview.scaled(800,424,Qt::IgnoreAspectRatio,Qt::FastTransformation);
    m_ui->okButton->setEnabled(true);
}

void BackgroundDlg::process_line(QString line, const int CONF_TYPE)
{
    switch(CONF_TYPE)
    {
        case THEME:
            if(line.contains(("name="), Qt::CaseInsensitive) && line.startsWith("n", Qt::CaseInsensitive))
                themeName = line.remove(0,5);
            break;
        case BACKGROUND:
            if(line.contains(("name="), Qt::CaseInsensitive) && line.startsWith("n", Qt::CaseInsensitive))
                backgroundName = line.remove(0,5);
            break;
    }
}
