#include "renameremotedlg.h"
#include "ui_renameremotedlg.h"

RenameRemoteDlg::RenameRemoteDlg(QWidget *parent, QString remoteName) :
    QDialog(parent),
    m_ui(new Ui::RenameRemoteDlg)
{
    m_ui->setupUi(this);
    m_ui->changeNameButton->setDisabled(true);
    this->setWindowTitle("Change remote name: " + remoteName);
    m_ui->remoteNameLine->setAlignment(Qt::AlignHCenter);
    connect(m_ui->remoteNameLine,SIGNAL(textChanged(QString)),this,SLOT(allowButton()));

}
RenameRemoteDlg::~RenameRemoteDlg()
{
    delete m_ui;
}
void RenameRemoteDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
void RenameRemoteDlg::on_changeNameButton_clicked()
{
    if(!m_ui->remoteNameLine->text().isEmpty()) {
        emit changeName(m_ui->remoteNameLine->text());
        emit newRemote(m_ui->remoteNameLine->text());
        this->close();
    }
    else if(m_ui->remoteNameLine->isHidden()) {
        emit deleteRemote();
        this->close();
    }
}
void RenameRemoteDlg::setNameLabelText(QString text)
{
    m_ui->nameLabel->setText(text);
}
void RenameRemoteDlg::setPushButtonText(QString text)
{
    m_ui->changeNameButton->setText(text);
}
void RenameRemoteDlg::setLabelGeometry(int x,int y,int width,int height)
{
    m_ui->nameLabel->setGeometry(x,y,width,height);
}
void RenameRemoteDlg::setPushButtonGeometry(int x,int y,int width,int height)
{
    m_ui->changeNameButton->setGeometry(x,y,width,height);
}
void RenameRemoteDlg::hideLineEdit()
{
    m_ui->remoteNameLine->hide();
}
void RenameRemoteDlg::allowButton()
{
    if(m_ui->remoteNameLine->text().isEmpty())
        m_ui->changeNameButton->setDisabled(true);
    else m_ui->changeNameButton->setEnabled(true);
}

void RenameRemoteDlg::enableButton(bool enabled)
{
    m_ui->changeNameButton->setEnabled(enabled);
}
