/*!
  @file
  QxtXmlRpc, a Qt4 library for XML-RPC network communication

  (C) 2006 Music Pictures, Ltd. (www.musicpictures.com)
  @author Tobias G. Pfeiffer (tgpfeiffer@web.de)
  @date 2007/02/05
  @version 0.3

  See http://qtnode.net/wiki/QxtXmlRpc or the README file for license terms.
*/

#include <QtCore>

#include "qxtxmlrpcclient.h"
#include "qxtxmlrpcrequestcomposer.h"
#include "qxtxmlrpcresponseparser.h"
#include <QWidget>


QxtXmlRpcClient::QxtXmlRpcClient(QWidget *parent, QUrl serverUrl) :
        url(serverUrl)
{
    http = new QHttp();
    http->setHost(url.host(),QHttp::ConnectionModeHttp, url.port());
    connect(http, SIGNAL(requestFinished(int, bool)), this, SLOT(handleResponse(int, bool)));
}

QxtXmlRpcClient::~QxtXmlRpcClient() {
    delete http;
}

int QxtXmlRpcClient::call(QString procName, QList<QVariant> params) {
    QxtXmlRpcRequestComposer composer(procName);
    QVariant var;
    foreach(var, params) {
        composer.appendArgument( var );
    }
    QByteArray xml = composer.getXmlRequest().toUtf8();
    QHttpRequestHeader header("POST", url.path());
    // add the port from the URL if set
    header.setValue("Host", url.host() + ((url.port() != -1) ? (QString(":").number(url.port())) : "" ));
    //if a username is present, then add Basic authentication Header
    if(url.userName().length() > 0) {
        header.setValue("Authorization", "Basic " + (url.userName().append(":").append(url.password())).toAscii().toBase64());
    }
    header.setValue("User-Agent", "QtIrreco");
    header.setValue("Content-Type", "text/xml");
    QIODevice* dev = new QBuffer();
    int req = http->request(header, xml, dev);
    requests[req] = dev;
    return req;
}

void QxtXmlRpcClient::handleResponse(int req, bool error) {
    if (error) {
        // throw error
        qDebug("an error occured");
        QIODevice* dev = requests.take(req);
        dev->close();
        delete dev;
        emit(networkError(req, http->errorString()));
    }
    if (requests.keys().contains( req ))
    {
        QIODevice* dev = requests.take(req);
        dev->close();
        dev->open( QIODevice::ReadOnly );
        QByteArray data = dev->readAll();
        delete dev;
        QList<QVariant> args;
        QString sdata = QString::fromUtf8( data );
        try {
            QxtXmlRpcResponseParser rp(sdata);
            emit(finish( req, rp.returnValue() ));
        } catch (QxtXmlRpcFault f) {
            emit(fault(req, f.faultCode(), f.faultString()));
        } catch (QxtXmlRpcParseError e) {
            emit(parseError(req, e.errorMsg()));
        }
    }
}
