#ifndef CREATEBUTTONDLG_H
#define CREATEBUTTONDLG_H

#include <QtGui/QDialog>
#include <QFileDialog>
#include <QFontDialog>
#include <QMouseEvent>
#include "themecreatorbutton.h"
#include <QMessageBox>
#include "definitions.h"

namespace Ui {
    class CreateButtonDlg;
}

class CreateButtonDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(CreateButtonDlg)
public:
    //! Constructor.
    explicit CreateButtonDlg(QWidget *parent = 0,QVector <ThemeCreatorButton*> *buttonsVector = 0);
    //! Constructor used when editing button.
    explicit CreateButtonDlg(QWidget *parent = 0,ThemeCreatorButton *button = 0,QVector <ThemeCreatorButton*> *buttonsVector = 0);
    //! Destructor.
    virtual ~CreateButtonDlg();
    //! Method to set addbutton text to Edit.
    void setAddButtonText(QString text);

protected:
    virtual void changeEvent(QEvent *e);
    void mousePressEvent(QMouseEvent *event);

private:
    Ui::CreateButtonDlg *m_ui;
    //! Button unpressed path.
    QString fileNameUp;
    //! Button pressed path.
    QString fileNameDown;
    //! Boolean which tells if file dialog can open when clicking pressed image.
    bool enablePressed;
    //! Pressed buttons pixmap.
    QPixmap pressedPix;
    //! Unressed buttons pixmap.
    QPixmap unpressedPix;
    //! Font for pressed button.
    QFont pressedFont;
    //! Font for unpressed button.
    QFont unpressedFont;
    //! Buttons name.
    QString buttonName;
    //! Boolean which tells if text allowed on button.
    bool enableFont;
    //! Contains all buttons on theme.
    QVector <ThemeCreatorButton*> *buttons;
    //! Copy for editing button.
    ThemeCreatorButton *b;
    //! Boolean to tell if editing or adding button.
    bool edit;

    void createList();

private slots:
    //! Slot to allow text on button.
    void allowPushButton_clicked();
    //! Opens font dialog.
    void on_txtDownPushButton_clicked();
    void on_txtUpPushButton_clicked();
    //! Opens file dialog.
    void on_pressedPushButton_clicked();
    void on_unpressedPushButton_clicked();
    //! Emits button to ThemeCreator.
    void addButtonClicked();
signals:
    //! Contains button information.
    void createButton(QString buttonName,QPixmap pressedPix,QPixmap unpressedPix,QFont pressedFont,QFont unpressedFont,
                      bool fontEnabled, QString pressedPath,QString unpressedPath);
};
#endif // CREATEBUTTONDLG_H
