#include "buttonselectdlg.h"
#include "ui_buttonselectdlg.h"

ButtonSelectDlg::ButtonSelectDlg(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::ButtonSelectDlg)
{
    m_ui->setupUi(this);
    this->setWindowTitle("Select button image");
    m_ui->selectPushButton->setDisabled(true);
	 connect(m_ui->HWlistWidget,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(setButtonsOnListWidget2(QListWidgetItem*)));
    connect(m_ui->HWbuttonListWidget,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(setButton()));
    loadThemes();
    defaultflag = false;
}

ButtonSelectDlg::~ButtonSelectDlg()
{
    delete m_ui;
}

void ButtonSelectDlg::loadThemes()
{
    themeDirList.clear();
    QDir themeDirs(themesPath);

    themeDirList = themeDirs.entryList(QDir::NoDotAndDotDot | QDir::Dirs, QDir::Name);
    themeDirList.insert(0,"default");

    for(int i = 0 ; i < themeDirList.count() ; i++) {
        QListWidgetItem *item = new QListWidgetItem();
        QString themeConf;

        if(themeDirList.at(i) == "default")
            themeConf = defaultThemeConf;

        else  themeConf = themesPath + themeDirList.at(i) + "/theme.conf";

        QFile file(themeConf);
        if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
            QMessageBox::warning(this,"Error with theme config","Couldn't load " + themeDirList.at(i) + " theme config file!" +
                                 " Please download theme again from theme manager.",
                                 QMessageBox::NoButton,QMessageBox::NoButton);
            themeDirList.removeAt(i);
            i--;
        }

        else {
            QTextStream in(&file);
            while (!in.atEnd()) {
                QString line = in.readLine();
                process_line(line, THEME);
            }
            item->setText(themeName);

            m_ui->HWlistWidget->insertItem(i, item);
            m_ui->HWlistWidget->show();
        }

    
    }
}

void ButtonSelectDlg::setButtonsOnListWidget2(QListWidgetItem *item)
{
    m_ui->selectPushButton->setDisabled(true);
    buttonDirList.clear();
    m_ui->label->clear();
    themeIndex = m_ui->HWlistWidget->currentRow();

    m_ui->HWbuttonListWidget->clear();

    if(item->text() == "Default") {
        QDir currentThemeDir(defaultButtonsPath);
        buttonDirList = currentThemeDir.entryList(QDir::NoDotAndDotDot | QDir::Dirs, QDir::Name);
        defaultflag = true;
    }
    else {
        QDir currentThemeDir(themesPath + themeDirList.at(themeIndex) +"/buttons/");
        buttonDirList = currentThemeDir.entryList(QDir::NoDotAndDotDot | QDir::Dirs, QDir::Name);
        defaultflag = false;
    }

    for(int i = 0 ; i < buttonDirList.count() ; i++) {
        QListWidgetItem *item = new QListWidgetItem();
        QString buttonConf;

        if(defaultflag)
            buttonConf = defaultButtonsPath + buttonDirList.at(i) + "/button.conf";

        else buttonConf = themesPath + themeDirList.at(themeIndex) + "/buttons/" + buttonDirList.at(i) + "/button.conf";

        QFile file(buttonConf);
        if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
            QMessageBox::warning(this,"Error with button config","Couldn't load button config file!",
                                 QMessageBox::NoButton,QMessageBox::NoButton);
            return;
        }

        QTextStream in(&file);
        while (!in.atEnd()) {
            QString line = in.readLine();
            process_line(line, BUTTON);
        }
        file.close();
        if(defaultflag) {
            QIcon icon(defaultButtonsPath + buttonDirList.at(i) + "/" + upButtonName);
            item->setIcon(icon);
            item->setText(buttonName);
        }
        else {
            QIcon icon(themesPath + themeDirList.at(themeIndex) + "/buttons/" + buttonDirList.at(i) + "/" + upButtonName);
            item->setIcon(icon);
            item->setText(buttonName);
        }

        m_ui->HWbuttonListWidget->insertItem(i, item);
        m_ui->HWbuttonListWidget->show();
    }
}

void ButtonSelectDlg::setButton()
{
    m_ui->selectPushButton->setEnabled(true);
    buttonIndex = m_ui->HWbuttonListWidget->currentRow();
    if(defaultflag) {
        QPixmap pix(defaultButtonsPath + buttonDirList.at(buttonIndex) + "/" + upButtonName);
        m_ui->label->setPixmap(pix.scaled(128,128,Qt::KeepAspectRatio,Qt::FastTransformation));
        m_ui->label->setAlignment(Qt::AlignCenter);
        m_ui->selectPushButton->setEnabled(true);
    }
    else {
        QPixmap pix(themesPath + themeDirList.at(themeIndex) + "/buttons/" + buttonDirList.at(buttonIndex) + "/" + upButtonName);
        m_ui->label->setPixmap(pix.scaled(128,128,Qt::KeepAspectRatio,Qt::FastTransformation));
        m_ui->label->setAlignment(Qt::AlignCenter);
        m_ui->selectPushButton->setEnabled(true);
    }
}

void ButtonSelectDlg::on_selectPushButton_clicked()
{

    if(defaultflag) {
        fileNameUnPressed = (defaultButtonsPath + buttonDirList.at(buttonIndex) + "/" + upButtonName);
        fileNamePressed = (defaultButtonsPath + buttonDirList.at(buttonIndex) + "/" + downButtonName);
        confFileName = (defaultButtonsPath + buttonDirList.at(buttonIndex) + "/button.conf");
    }
    else if(!defaultflag)
    {
        fileNameUnPressed = (themesPath + themeDirList.at(themeIndex) + "/buttons/" + buttonDirList.at(buttonIndex) + "/" + upButtonName);
        fileNamePressed = (themesPath + themeDirList.at(themeIndex) + "/buttons/" + buttonDirList.at(buttonIndex) + "/" + downButtonName);
        confFileName = (themesPath + themeDirList.at(themeIndex) + "/buttons/" + buttonDirList.at(buttonIndex) + "/button.conf");
    }
    emit signalAddButton(fileNameUnPressed, fileNamePressed, confFileName);
    this->close();
}

void ButtonSelectDlg::process_line(QString line, int CONF_TYPE)
{
    switch(CONF_TYPE) {
        case THEME:
            if(line.contains("name=", Qt::CaseInsensitive) && line.startsWith("n", Qt::CaseInsensitive))
                themeName = line.remove(0,5);
            break;

        case BUTTON:
            if(line.contains("name=", Qt::CaseInsensitive) && line.startsWith("n", Qt::CaseInsensitive))
                buttonName = line.remove(0,5);
            if(line.contains("up=", Qt::CaseInsensitive) && line.startsWith("u", Qt::CaseInsensitive))
                upButtonName = line.remove(0,3);
            if(line.contains("down=", Qt::CaseInsensitive) && line.startsWith("d", Qt::CaseInsensitive))
                downButtonName = line.remove(0,5);
            break;
    }
}
