#include "downloadremotedlg.h"
#include "ui_downloadremotedlg.h"

DownloadRemoteDlg::DownloadRemoteDlg(QWidget *parent, bool remoteStartupOnOff, QStringList *remotes) :
    QDialog(parent),
    m_ui(new Ui::DownloadRemoteDlg)
{
    remoteNames = remotes;
    remoteStartup = remoteStartupOnOff;
    m_ui->setupUi(this);
    this->setWindowTitle("Download remote");

    QUrl url;
    url.setHost("mercury.wipsl.com");
    url.setPath("/irreco/webdb/");
    url.setPort(80);

    client = new QxtXmlRpcClient(this, url);
    connect(client,SIGNAL(finish(int,QVariant)),this,SLOT(processReturnValue(int,QVariant)));
    connect(client,SIGNAL(networkError(int,QString)),this,SLOT(error(int,QString)));
    connect(client,SIGNAL(fault(int,int,QString)),this,SLOT(fault(int,int,QString)));
    QList<QVariant> list;
    list.clear();
    alphabeticalId = client->call("getLircDirs",list);

    connect(m_ui->alphabeticalList,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(getManufacturers(QListWidgetItem*)));
    connect(m_ui->manufacturerList,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(getModels(QListWidgetItem*)));
    connect(m_ui->remoteList,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(getFile()));
}

DownloadRemoteDlg::~DownloadRemoteDlg()
{
    delete m_ui;
}

void DownloadRemoteDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void DownloadRemoteDlg::getManufacturers(QListWidgetItem* item)
{
    rangeItemString =item->text();
    QList<QVariant> range;
    range.append(rangeItemString);
    manufacturerId = client->call("getLircManufacturers",range);
}
void DownloadRemoteDlg::getModels(QListWidgetItem* item)
{
    manufacturerItemString = rangeItemString+ "/" + item->text();
    QList<QVariant> manufacturer;
    manufacturer.append(manufacturerItemString);
    modelId = client->call("getLircModels",manufacturer);
}
void DownloadRemoteDlg::getFile()
{
    modelItemString = manufacturerItemString + "/" + m_ui->remoteList->currentItem()->text();
    modelItem = m_ui->remoteList->currentItem()->text();
    QList<QVariant> file;
    file.append(modelItemString);
    fileId = client->call("getLircFile",file);
}
void DownloadRemoteDlg::processReturnValue(int Id,QVariant data)
{
    QStringList sList;
    sList = data.toStringList();

    if (Id == alphabeticalId) {
        m_ui->alphabeticalList->clear();
        m_ui->manufacturerList->clear();
        m_ui->remoteList->clear();
        m_ui->alphabeticalList->insertItems(0,sList);
    }
    if (Id == manufacturerId) {
        m_ui->manufacturerList->clear();
        m_ui->remoteList->clear();
        m_ui->manufacturerList->insertItems(0,sList);
    }
    if (Id == modelId) {
        m_ui->remoteList->clear();
        m_ui->remoteList->insertItems(0,sList);
    }
    if (Id == fileId) {
        QDir dir;
        if(!dir.exists(devicesPath))
            dir.mkpath(devicesPath);
        if(!QFile::exists(devicesPath + modelItem)) {
            QFile deviceFile(devicesPath + modelItem);
            deviceFile.open(QIODevice::WriteOnly | QIODevice::Text);
            QTextStream out(&deviceFile);
            for(int i= 0; i< sList.count();i++) { // Streams only one remote data to file
                QString line = sList.at(i);
                out << sList.at(i); // Original line
                if(line.contains("end remote",Qt::CaseInsensitive))
                    break;

            }

            deviceFile.close();

            QFile LircConfFile("/etc/lircd.conf");
            QStringList deviceList;
            LircConfFile.open(QIODevice::ReadWrite | QIODevice::Text);
            QTextStream io(&LircConfFile);
            while (!io.atEnd()) {
                QString line = io.readLine();
                deviceList.append(line);
            }
            LircConfFile.resize(0);
            QString lastLine;

            for(int j = 0; j<sList.count();j++) {
                lastLine =  sList.at(j);

                if (lastLine.contains("end", Qt::CaseInsensitive)) {
                    if(!deviceList.contains(modelItem,Qt::CaseInsensitive))
                       deviceList.append("include \"/home/user/MyDocs/qtirreco/Devices/" + modelItem + "\"");
                    for(int i= 0; i< deviceList.count();i++) {
                        io << deviceList.at(i)+"\n";
                    }
                    j=sList.count();
                }
            }
            LircConfFile.close();

            QString para = modelItem;
            if(remoteStartup) {
                remotestartupdlg = new RemoteStartupDlg(para, this, remoteNames);
                connect(remotestartupdlg,SIGNAL(addButtonToLayoutSignalFromRSD(QString,QString,QString,QString,QStringList,int)),this,SLOT(AddButtonToLayout(QString, QString,QString,QString,QStringList,int)));
                connect(remotestartupdlg,SIGNAL(remoteCreated(QString)),this,SLOT(enableRemoteNameAdding(QString)));
                connect(remotestartupdlg,SIGNAL(lwClear()),this,SLOT(clearScreenForNewRemote()));
                remotestartupdlg->exec();
                delete remotestartupdlg;
            }
            QFile lircPathsFile(lircpathsConf);
            lircPathsFile.open(QIODevice::ReadWrite | QIODevice::Append);
            QTextStream stream(&lircPathsFile);
            bool lircExists = false;
            while(!stream.atEnd())
            {
                QString line = stream.readLine();
                if(line.contains(para,Qt::CaseInsensitive))
                    lircExists = true;
            }
            if(!lircExists)
                stream << para + " "+ modelItemString + "\n";

            lircPathsFile.close();
            this->close();
        }
        else {
              if(remoteStartup) {
                        QString para = modelItem;
                        remotestartupdlg = new RemoteStartupDlg(para, this, remoteNames);
                        connect(remotestartupdlg,SIGNAL(addButtonToLayoutSignalFromRSD(QString,QString,QString,QString,QStringList,int)),this,SLOT(AddButtonToLayout(QString, QString,QString,QString,QStringList,int)));
                        connect(remotestartupdlg,SIGNAL(remoteCreated(QString)),this,SLOT(enableRemoteNameAdding(QString)));
                        connect(remotestartupdlg,SIGNAL(lwClear()),this,SLOT(clearScreenForNewRemote()));
                        remotestartupdlg->exec();
                        delete remotestartupdlg;
                   }


              }

              this->close();
        }
}
void DownloadRemoteDlg::error(int i ,QString string)
{
    QMessageBox::warning(this,"Error",string,
                                 QMessageBox::NoButton,QMessageBox::NoButton);
}
void DownloadRemoteDlg::fault(int i,int j,QString string)
{
    QMessageBox::warning(this,"Error",string,
                                 QMessageBox::NoButton,QMessageBox::NoButton);
}
void DownloadRemoteDlg::AddButtonToLayout(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList aCommand, int number)
{
    emit addButtonToLayoutSignalFromRSD(fileNameUnPressed, fileNamePressed, confFileName, buttonText, aCommand, number);
}
void DownloadRemoteDlg::enableRemoteNameAdding(const QString &remoteName)
{
    emit remoteNameToLayoutWidget(remoteName);
}
void DownloadRemoteDlg::clearScreenForNewRemote()
{
    emit lwClearScreen();
}
