#ifndef THEMEPREVIEWBUTTONDLG_H
#define THEMEPREVIEWBUTTONDLG_H

#include <QtGui/QDialog>
#include "themecreatorbutton.h"

namespace Ui {
    class ThemePreviewButtonDlg;
}

class ThemePreviewButtonDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(ThemePreviewButtonDlg)
public:
    //! Constructor.
    explicit ThemePreviewButtonDlg(QWidget *parent = 0,QVector <ThemeCreatorButton*> *buttonsVector = 0);
    //! Destructor.
    virtual ~ThemePreviewButtonDlg();

protected:
    virtual void changeEvent(QEvent *e);
    void mousePressEvent(QMouseEvent *event);

private:
    Ui::ThemePreviewButtonDlg *m_ui;
    //! Vectors for needed button datas.
    QVector <QLabel*> *buttons;
    QVector <QString> *paths;
    QVector <QString> *names;
signals:
    //! Signal for Theme Manager to emit button path and name.
    void setPreviewButton(QString previewPath,QString buttonName);
};
#endif // THEMEPREVIEWBUTTONDLG_H
