#ifndef THEMECREATORBUTTON_H
#define THEMECREATORBUTTON_H

#include <QtGui/QDialog>
#include <QLabel>

class ThemeCreatorButton : public QWidget
{
    Q_OBJECT
public:
    //! Constructor.
    explicit ThemeCreatorButton(QWidget *parent = 0);
    //! Destructor.
    virtual ~ThemeCreatorButton();
    //! Name of button.
    QString buttonName;
    //! Button pixmaps.
    QPixmap pressedPix;
    QPixmap unpressedPix;
    //! Button file paths.
    QString pressedPath;
    QString unpressedPath;
    //! Button fonts.
    QFont pressedFont;
    QFont unpressedFont;
    //! Boolean to tell if font enabled in button.
    bool enableFont;
    //! Labels for button data.
    QLabel *unpressed;
    QLabel *pressed;
    QLabel *name;
    //! Method for creating labels in widget.
    void createLabels(QString buttonName, QPixmap pressedPix, QPixmap unpressedPix);
    //! Method for deleting labels.
    void deleteLabels();
};
#endif // THEMECREATORBUTTON_H
