#include "themecreatorbutton.h"


ThemeCreatorButton::ThemeCreatorButton(QWidget *parent) :
        QWidget(parent)
{
    this->resize(781,104);

}
ThemeCreatorButton::~ThemeCreatorButton()
{
}
void ThemeCreatorButton::createLabels(QString buttonName, QPixmap pressedPix, QPixmap unpressedPix)
{
    unpressed = new QLabel(this);
    pressed = new QLabel(this);
    name = new QLabel(this);

    unpressed->setPixmap(unpressedPix.scaled(96,96,Qt::KeepAspectRatio,Qt::FastTransformation));
    pressed->setPixmap(pressedPix.scaled(96,96,Qt::KeepAspectRatio,Qt::FastTransformation));
    name->setText(buttonName);

    unpressed->setGeometry(20,4,96,96);
    pressed->setGeometry(250,4,96,96);
    name->setGeometry(480,40,256,24);

    name->setFont(QFont("sans-serif",16));
    name->setAlignment(Qt::AlignVCenter);

    unpressed->show();
    pressed->show();
    name->show();

}
void ThemeCreatorButton::deleteLabels()
{
    delete unpressed;
    delete pressed;
    delete name;
}
