#include "layoutwidget.h"
#include "buttonwidget.h"

#define LIRCD "/dev/lircd"


LayoutWidget::LayoutWidget(QMainWindow *parent ) : QWidget( parent )
{
    this->resize(800,424);
    setAcceptDrops(true);
    useModeEnabled = true;
    buttonsVisible = true;
    vector = new QVector<ButtonWidget*>;
    bgPath = QString::fromUtf8("/home/user/.qtirreco/themes/default/bg/qtirreco/irreco_logo.png");
    socket = new Socket(this);
    timer = new QTimer(this);
    timer2 = new QTimer(this);
    timer2Index = 0;
    timeout2 = 1;
    connect(timer,SIGNAL(timeout()),this,SLOT(sendIrCommandsSlot()));
    connect(timer2,SIGNAL(timeout()),this,SLOT(sendIrCommandsSlot2()));
    timeout = 1000;
    timer->setInterval(timeout);
    timer2->setInterval(timeout2);
    socket->create();
    bool connected = socket->connect("localhost", 8765);
    if(!connected) QMessageBox::warning(this,"Socket connection","Socket connection failed!");
}

LayoutWidget::~LayoutWidget()
{
    //socket->closeSocket();

}
void LayoutWidget::setUseModeEnabled(bool useMode)
{
    useModeEnabled = useMode;
    if(!useMode) {
        timer->stop();
        timer2->stop();
    }
}

void LayoutWidget::setButtonsVisible(bool menuButtonsVisible)
{
    buttonsVisible = menuButtonsVisible;
}

void LayoutWidget::openEditDlg()
{
    NewButtonDlg *newButtonDlg = new NewButtonDlg(this,vector->at(currentButtonIndex), vector);
    connect(newButtonDlg,SIGNAL(addButtonToLayoutSignal(QString,QString, QString, QString,QStringList,int,int)),
            this,SLOT(editButton(QString,QString, QString, QString, QStringList,int,int)));

    newButtonDlg->exec();
    delete newButtonDlg;
}

void LayoutWidget::editButton(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList commands, int number, int timeOut)
{
     QPoint position = newButton->pos();

     ButtonWidget *pw = new ButtonWidget(this, fileNameUnPressed, fileNamePressed, confFileName, buttonText, commands, timeOut);

     int buttonWidgets;
     buttonWidgets = vector->count();
     for(int i=0;i<buttonWidgets;i++) {
        if(vector->at(i)->buttonText == newButton->buttonText) {
            vector->replace(i,pw);
        }
     }
     pw->move(position);
     pw->show();
     newButton->deleteLater();
     emit showOrHideMenu();
}

void LayoutWidget::mousePressEvent(QMouseEvent *event)
{
    ButtonWidget *child = static_cast<ButtonWidget*>(childAt(event->pos()));
    if (!child) {
            emit showOrHideMenu();
            return;
        }

    QPoint hotSpot = event->pos() - child->pos();
    xPos = child->x();
    yPos = child->y();

    QByteArray itemData;
    QDataStream dataStream(&itemData, QIODevice::WriteOnly);
    dataStream << QPoint(hotSpot) << (child->fileNameUnPressed) << (child->fileNamePressed) << (child->confFileName) << (child->buttonText) << (child->commandChain) << (child->timeOut);

    QMimeData *mimeData = new QMimeData;
    mimeData->setData("application/x-qtirreco", itemData);
    mimeData->setText(child->fileNameUnPressed);

    if(useModeEnabled) {
        copyButton = child;
        QDrag *drag = new QDrag(this);
        drag->setMimeData(mimeData);
        drag->setPixmap(*child->pressedPixmap);
        drag->setHotSpot(hotSpot);
        drag->exec();
            if(child->commandChain.count() < 2)
                this->sendIrCommands(child->commandChain);

    }
    else {
        QDrag *drag = new QDrag(this);
        drag->setMimeData(mimeData);
        drag->setPixmap(*child->pressedPixmap);

        drag->setHotSpot(hotSpot);

        child->hide();

        if (drag->exec(Qt::MoveAction | Qt::CopyAction, Qt::CopyAction) == Qt::MoveAction)
            child->close();
        else child->show();
    }
 }

void LayoutWidget::dragEnterEvent(QDragEnterEvent *event)
 {
    if(!useModeEnabled) {
         if (event->mimeData()->hasFormat("application/x-qtirreco")) {
         if (children().contains(event->source())) {
             event->setDropAction(Qt::MoveAction);
             event->accept();
             } else
                 event->acceptProposedAction();

         } else if (event->mimeData()->hasText())
             event->acceptProposedAction();
          else
             event->ignore();

    }
    else {
        if(copyButton->commandChain.count() > 1 && copyButton->underMouse())
            this->sendIrCommands(copyButton->commandChain);
        else if(copyButton->underMouse() && !timer->isActive()) {
            timeout = 1000;
            timer->setInterval(timeout);
            timer->start();
        }
          if (event->mimeData()->hasFormat("application/x-qtirreco")) {
         if (children().contains(event->source())) {
             event->setDropAction(Qt::MoveAction);
             event->accept();
             } else
                 event->acceptProposedAction();

         } else if (event->mimeData()->hasText())
             event->acceptProposedAction();
          else
             event->ignore();
     }
 }
 void LayoutWidget::dragMoveEvent(QDragMoveEvent *event)
 {
     if(!useModeEnabled) {
        if (event->mimeData()->hasFormat("application/x-qtirreco")) {
             if (children().contains(event->source())) {
                 event->setDropAction(Qt::MoveAction);
                 event->accept();
             } else
                 event->acceptProposedAction();

         } else if (event->mimeData()->hasText())
             event->acceptProposedAction();
          else
             event->ignore();

     }
     else {
         if (event->mimeData()->hasFormat("application/x-qtirreco")) {
         if (children().contains(event->source())) {
             event->setDropAction(Qt::MoveAction);
             event->accept();
             } else
                 event->acceptProposedAction();

         } else if (event->mimeData()->hasText())
             event->acceptProposedAction();
          else
             event->ignore();
     }

 }
 void LayoutWidget::dropEvent(QDropEvent *event)
 {

    if(!useModeEnabled) {
         if (event->mimeData()->hasFormat("application/x-qtirreco")) {
             QByteArray itemData = event->mimeData()->data("application/x-qtirreco");
             QDataStream dataStream(&itemData, QIODevice::ReadOnly);

             QPoint offset;
             QString fileNameUnPressed;
             QString fileNamePressed;
             QString confFileName;
             QString buttonText;
             QStringList commands;
             int timeOut;

             dataStream >> offset >> fileNameUnPressed >> fileNamePressed >> confFileName >> buttonText >> commands >> timeOut;

             newButton = new ButtonWidget(this, fileNameUnPressed, fileNamePressed, confFileName, buttonText, commands, timeOut);
             newButton->move(event->pos() - offset);
             newButton->show();
             newButton->setAttribute(Qt::WA_DeleteOnClose);

             int buttonWidgets;
             buttonWidgets = vector->count();
             for(int i=0;i<buttonWidgets;i++) {
                if(vector->at(i)->buttonText == newButton->buttonText) {
                    vector->replace(i,newButton);
                    currentButtonIndex = i;
                }
             }

             if (event->source() == this) {
                 event->setDropAction(Qt::MoveAction);
                 event->accept();
             }
             else event->acceptProposedAction();
         }
         else event->ignore();

         // Move button to limit area if it goes over screen area
         int buttonWidth = newButton->width();
         int buttonHeight = newButton->height();
         bool negativePos = false;

         if(((newButton->x())+(buttonWidth)) > 800)
            newButton->move(800-buttonWidth,newButton->y());

         if(newButton->x() < 0) {
            newButton->move(0,newButton->y());
            negativePos = true;
         }
         if(newButton->y()+buttonHeight > 424)
            newButton->move(newButton->x(),424 - buttonHeight);

         if(newButton->y() <= 0) {
            newButton->move(newButton->x(),0);
            negativePos = true;
         }
         // End
          if(!negativePos) {
             if((xPos-newButton->x()) < 30 && (xPos-newButton->x()) > -30 &&
                    (yPos-newButton->y()) < 30 && (yPos-newButton->y()) > -30) {

                 QMenu *menu = new QMenu(newButton);

                 if(newButton->x() <= 300)
                     menu->setGeometry(QRect(newButton->x()+105,newButton->y()+75,50,20));

                 else menu->setGeometry(QRect(newButton->x()-235,newButton->y()+75,50,20));

                 menu->setFont(QFont("sans-serif",22,QFont::Bold));
                 QAction *editButton = menu->addAction("Edit button");
                 menu->addSeparator();
                 QAction *deleteButton = menu->addAction("Delete button");

                 connect(editButton,SIGNAL(triggered()),this,SLOT(openEditDlg()));
                 connect(deleteButton,SIGNAL(triggered()),this,SLOT(deleteButton()));
                 menu->show();
             }
         }
     }
    else {
        timer->stop();
        //timeout = 1000;
        }
}
void LayoutWidget::deleteButton()
{
    vector->at(currentButtonIndex)->deleteLater();
    vector->remove(currentButtonIndex);
}
void LayoutWidget::clearScreen()
{
    for (int i=0;i<vector->count();i++) {
        vector->at(i)->deleteLater();
    }
    vector->clear();
}
void LayoutWidget::addButton(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList commands, QPoint position,int timeOut)
{
     ButtonWidget *pw = new ButtonWidget(this, fileNameUnPressed, fileNamePressed, confFileName, buttonText, commands, timeOut);

     vector->append(pw);
     pw->move(position);
     pw->show();
}

void LayoutWidget::addButton(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList commands, int aNumber)
{
     int timeOut = 600;
     ButtonWidget *pw = new ButtonWidget(this, fileNameUnPressed, fileNamePressed, confFileName, buttonText, commands, timeOut);
     number = aNumber;
     int xPlace = 0;
     int yPlace = 0;
    if(number < 6) {
        xPlace = number * 128;
        yPlace = 0;
    }
    if(number > 5 && number < 12) {
        xPlace = (number - 6) * 128;
        yPlace = 128;
    }
    if(number > 11 && number < 18) {
        xPlace = (number - 12) * 128;
        yPlace = 256;
    }
    vector->append(pw);
    pw->move(xPlace, yPlace);
    pw->show();
 }

 void LayoutWidget::setBackgroundMode(QString mode)
 {
    backgroundMode = mode;
 }

 void LayoutWidget::setActiveRemoteName(QString activeRemote)
 {
     activeRemoteName = activeRemote; // remote name without .conf
 }

 void LayoutWidget::setRgbInteger(int aR,int aG,int aB)
 {
     r.setNum(aR);
     g.setNum(aG);
     b.setNum(aB);
 }

 void LayoutWidget::saveRemoteToFile()
 {
     QStringList themesUsed;
     QStringList themeVersionsUsed;
     if(backgroundMode == "theme") {
        QString bgTheme = bgPath;
        bgTheme = bgTheme.remove(0,34);
        int slashIndex = bgTheme.indexOf(QChar('/'));
        bgTheme.remove(slashIndex,bgTheme.count()-slashIndex);
        if(!themesUsed.contains(bgTheme))
           themesUsed.append(bgTheme);
     }

    for( int i=0 ; i<vector->count() ; i++ ) {
        QString themeName;
        QString temp = vector->at(i)->fileNameUnPressed;
        if(!temp.contains("/home/user/.qtirreco")) {
            temp = temp.remove(0,34);
            int slashIndex = temp.indexOf(QChar('/'));
            temp.remove(slashIndex,temp.count()-slashIndex);
            themeName = temp;
            if(!themesUsed.contains(themeName))
                themesUsed.append(themeName);
        }
    }

    for( int i=0 ; i< themesUsed.count() ; i++ ) {
        QFile themeConf("/home/user/MyDocs/qtirreco/themes/" + themesUsed.at(i) + "/theme.conf");
        themeConf.open(QIODevice::ReadOnly | QIODevice::Text);
        QTextStream in(&themeConf);
        QString version;
        while (!in.atEnd()) {
            version = in.readLine();
            if(version.contains("version=")) {
                version = version.remove(0,8);
                themeVersionsUsed.append(version);
            }
        }
        themeConf.close();
    }


    QDir dir;
    if(!dir.exists(DEVICEREMOTES))
            dir.mkpath(DEVICEREMOTES);

    QFile exFile(DEVICEREMOTES + activeRemoteName+".conf");
    exFile.remove();
    QFile file(DEVICEREMOTES + activeRemoteName +".conf");
    file.open(QIODevice::WriteOnly | QIODevice::Text);

    QTextStream out(&file);

    if(backgroundMode == "default") {
        out << "Background: default \n";
        out << "Image: default \n";
    }
    else if(backgroundMode == "theme") {

        out << "Background: theme \n";
        out << "Image: "<< bgPath <<"\n";
    }
    else if(backgroundMode == "image") {
        out << "Background: image \n";
        out << "Image: "<< bgPath <<"\n";
    }
    else if(backgroundMode == "color_only") {
        out << "Background: color_only \n";
        out << "Color: " << r <<" "<< g <<" " << b << "\n";
    }
    int buttonCount = vector->count();
    if(buttonCount > 0) {
        for(int i=0 ; i < buttonCount ; i++) {
            out << "\nbutton: " << vector->at(i)->buttonText;
            out << "\nfileNameUnPressed: " << vector->at(i)->fileNameUnPressed;
            out << "\nfileNamePressed: " << vector->at(i)->fileNamePressed;
            out << "\nconfFileName: " << vector->at(i)->confFileName;
            out << "\nposition: " << vector->at(i)->pos().x() << ", " << vector->at(i)->pos().y();
                 if(vector->at(i)->commandChain.count() > 1)
            {
                QString time;
                time.setNum(vector->at(i)->timeOut);
                out << "\ntimeout: " + time;
            }
            out << "\ncommandChain:";
            int commandChainCount = vector->at(i)->commandChain.count();
            if(commandChainCount > 1) {
                for(int j=0 ; j < commandChainCount ; j++) {
                    out << "\ncommand: " << vector->at(i)->commandChain.at(j);
                }
            }
            if(commandChainCount == 1) {
                out << "\ncommand: " << vector->at(i)->commandChain.at(0);
            }
            out << "\nend commandChain\n";
            }
    }
    if(!themesUsed.isEmpty()) {
        out << "Themes: ";
        for(int i=0 ; i<themesUsed.count() ; i++)
            out << themesUsed.at(i) + " " ;

        out << "\nTheme versions: ";
        for(int i=0 ; i<themeVersionsUsed.count() ; i++)
            out << themeVersionsUsed.at(i) + "/" ;
    }

   themesUsed.clear();
   themeVersionsUsed.clear();
   file.close();


}


void LayoutWidget::setBackgroundImagePath(QString bgImagePath)
{
    bgPath = bgImagePath;
}

void LayoutWidget::setRgbValues(QString red,QString green,QString blue)
{
    r = red;
    g = green;
    b = blue;
}

void LayoutWidget::sendIrCommands(QStringList commands)
{

    if(commands.count() < 2) {
      //  socket->openSocket(LIRCD);
        const QString command = "SEND_ONCE " +commands.at(0);
        socket->sendSocket(&command);
    }
    else {
        timer2->setInterval(1);
        timer2->start();
    }
}
void LayoutWidget::sendIrCommandsSlot()
{
    if(timeout >= 200) {
        timeout -= 100;
        timer->setInterval(timeout);
    }
    sendIrCommands(copyButton->commandChain);

}
void LayoutWidget::sendIrCommandsSlot2()
{

    if(timer2Index < copyButton->commandChain.count()) {
         const QString command = "SEND_ONCE " +copyButton->commandChain.at(timer2Index);
         socket->sendSocket(&command);
         timer2Index++;
         timeout2 = copyButton->timeOut;
         timer2->setInterval(timeout2);
     }
    else {
        timer2->stop();
        timer2Index = 0;
    }

}
