#ifndef DOWNLOADREMOTEDLG_H
#define DOWNLOADREMOTEDLG_H

#include <QtGui/QDialog>
#include "qxtxmlrpcclient.h"
#include "remotestartupdlg.h"
#include "qtirreco.h"

namespace Ui {
    class DownloadRemoteDlg;
}

class DownloadRemoteDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(DownloadRemoteDlg)
public:
    //! Constructor.
    explicit DownloadRemoteDlg(QWidget *parent = 0, bool remoteStartupOnOff = true, QStringList *remotes = 0);
    //! Destructor.
    virtual ~DownloadRemoteDlg();
    //! Boolean for telling if downloading from RemoteStartupDlg or CommandChainDlg.
    bool remoteStartup;

protected:
    virtual void changeEvent(QEvent *e);

private:
    Ui::DownloadRemoteDlg *m_ui;
    //! Object for PHP calls.
    QxtXmlRpcClient *client;
    //! Object for RemoteStartupDlg.
    RemoteStartupDlg *remotestartupdlg;
    //! Variables used for client calls.
    int alphabeticalId;
    int manufacturerId;
    int modelId;
    int fileId;
    //! Strings containing downloaded information.
    QString manufacturerItemString;
    QString rangeItemString;
    QString modelItemString;
    QString modelItem;
    //! Holds remotenames.
    QStringList *remoteNames;

private slots:
    //! Slot performed when client gets finished signal.
    void processReturnValue(int Id,QVariant data);
    //! Slot performed when client gets error signal.
    void error(int i,QString string);
    //! Slot performed when client gets fault signal.
    void fault(int i,int j,QString string);
    //! Slot to get manufacturers from DB.
    void getManufacturers(QListWidgetItem* item);
    //! Slot to get manufacturer models from DB.
    void getModels(QListWidgetItem* item);
    //! Slot to get remote lirc file.
    void getFile();
    //! Emits button properties to QtIrreco class which emits them to LayoutWidget.
    void AddButtonToLayout(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList aCommand, int number);
    //! Slot for emitting remote name to LayoutWidget.
    void enableRemoteNameAdding(const QString &remoteName);
    //! Slot for emitting clear signal.
    void clearScreenForNewRemote();

signals:
    //! Signal for button properties.
    void addButtonToLayoutSignalFromRSD(QString fileNameUnPressed, QString fileNamePressed, QString confFileName,
                                        QString buttonTextToEmit, QStringList aCommand, int number);
    //! Signal for emitting remotename.
    void remoteNameToLayoutWidget(QString aRemoteName);
    //! Signal emitted for LayoutWidget to clear screen from buttons.
    void lwClearScreen();
};
#endif // DOWNLOADREMOTEDLG_H
