#ifndef BUTTONSELECTDLG_H
#define BUTTONSELECTDLG_H

#include <QtGui/QDialog>
#include <QLabel>
#include <QIcon>
#include <QFile>
#include <QPalette>
#include <QVector>
#include <QString>
#include <QFileDialog>
#include <QTextStream>
#include <QWidget>
#include "qtirreco.h"

#define THEME 0
#define BUTTON 1

namespace Ui {
    class ButtonSelectDlg;
}

class ButtonSelectDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(ButtonSelectDlg)
public:
    //! Constructor.
    explicit ButtonSelectDlg(QWidget *parent = 0);
    //! Destructor.
    virtual ~ButtonSelectDlg();

protected:
    virtual void changeEvent(QEvent *e);

private:
    Ui::ButtonSelectDlg *m_ui;
    //! Stringlist for theme directories.
    QStringList themeDirList;
    //! Stringlist for button directories.
    QStringList buttonDirList;
    //! Full name for down button.
    QString downButtonName;
    //! Full name for up button.
    QString upButtonName;
    //! Name for button.
    QString buttonName;
    //! Theme name.
    QString themeName;
    //! Selected theme index in listwidget.
    int themeIndex;
    //! Selected button index in listwidget.
    int buttonIndex;
    //! Method for reading theme and button configs.
    void process_line(QString line, int CONF_TYPE);
    //! Method for loading existing themes on device to listwidget.
    void loadThemes();

    bool defaultflag;

private slots:
    //! Emits button filenames and config filename to NewButtonDlg class.
    void on_selectPushButton_clicked();

    void setBackgroundsOnListWidget2(QListWidgetItem *item);
    //! Sets button pixmap to preview label.
    void setButton();

signals:
    //! Emits button filenames and config filename to NewButtonDlg class.
    void signalAddButton(QString fileNameUnPressed, QString fileNamePressed, QString confFileName);
};
#endif // BUTTONSELECTDLG_H
