#include "themepreviewbuttondlg.h"
#include "ui_themepreviewbuttondlg.h"

ThemePreviewButtonDlg::ThemePreviewButtonDlg(QWidget *parent,QVector <ThemeCreatorButton*> *buttonsVector) :
    QDialog(parent),
    m_ui(new Ui::ThemePreviewButtonDlg)
{
    m_ui->setupUi(this);
    buttons = new QVector <QLabel*>();
    paths = new QVector <QString>();
    names = new QVector <QString>();
    int count=0;
    int row=0;
    int x=0;
    for(int i=0;i<buttonsVector->count();i++)
    {
        if(count == 0)
        {
            x = 20+20+count*128;
        }
        if(count == 1)
        {
            x = 20+20+count*128;
        }
        else
        {
            x = 20+20*count+count*128;
        }

        QLabel *button = new QLabel(m_ui->previewScrollAreaWidgetContents);
        button->setGeometry(x,20+row*148,128,128);

        button->setPixmap(QPixmap(buttonsVector->at(i)->unpressedPath).scaled(128,128,Qt::IgnoreAspectRatio,Qt::FastTransformation));
        button->show();
        buttons->append(button);
        paths->append(buttonsVector->at(i)->unpressedPath);
        names->append(buttonsVector->at(i)->buttonName);
        if(x > 500)
        {
            x = 0;
           // x = 40+count*128;
            count = -1;
            row++;
            //if(row>1)
            //{
                m_ui->previewScrollAreaWidgetContents->setMinimumHeight(250*row);
            //}
        }
        count++;
    }

    this->setWindowTitle("Select preview button");

}

ThemePreviewButtonDlg::~ThemePreviewButtonDlg()
{
    delete m_ui;
}

void ThemePreviewButtonDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
void ThemePreviewButtonDlg::mousePressEvent(QMouseEvent *event)
{
      if(m_ui->previewScrollAreaWidgetContents->underMouse())
        {
            for(int i=0;i<buttons->count();i++)
            {
                if(buttons->at(i)->underMouse())
                {
                    emit setPreviewButton(paths->at(i),names->at(i));
                    this->close();
                }
            }
        }
}
