#ifndef THEMEMANAGER_H
#define THEMEMANAGER_H

#include <QtGui/QDialog>
#include "themecreatordlg.h"
#include "logindbdlg.h"
#include <QListWidgetItem>
#include "qxtxmlrpcclient.h"
#include <QMessageBox>
#include <QTextStream>
#include <QProgressBar>
#include <QBuffer>

namespace Ui {
    class ThemeManager;
}

class ThemeManager : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(ThemeManager)
public:
    //! Constructor.
    explicit ThemeManager(QWidget *parent = 0);
    //! Destructor.
    virtual ~ThemeManager();

protected:
    virtual void changeEvent(QEvent *e);

private:
    Ui::ThemeManager *m_ui;
    void process_line(QString line);
    void readThemeConf(QString line);
    void readUsedThemes(QString line);
    //! List contains theme names used by remote.
    QStringList usedThemesByRemote;
    QStringList usedThemes;
    QString themeName;
    QStringList themeDirList;
    int deviceThemeCount;
    QStringList strList;
    bool deviceThemes;
    void getThemeIdsFromDb();
    //! Client used for DB calls.
    QxtXmlRpcClient *client;
    //! Helping variables for client to handle different DB data.
    int themeIds;
    int themeNames;
    int themeDatas;
    int themeVersionIds;
    int themeVersionDates;
    int themePreviewImage;
    //! List for theme ids.
    QStringList dbThemeIdList;
    //! List for theme names.
    QStringList dbThemeNamesList;
    //! Map containing theme name and id couples.
    QMap<QString, int> themeMap;
    //! Map containing theme version and id couples.
    QMap<QString, int> themeVersions;
    //! Method to get theme name by id.
    void getThemeNamesByIds();
    //! Helping index for getThemeNamesByIds() method to get all theme names from DB.
    int themeNameIndex;
    //! Method to get theme version ids by theme name.
    void getThemeVersionIdsByName(QString themeName);
    //! List for theme version ids.
    QStringList dbThemeVersionIdList;
    //! List for theme versions.
    QStringList dbThemeDateList;
    //! Helping variables to fill theme version list.
    int themeVersionIndex;
    int themeDates;
    //! For managing combobox when different version clicked
    int currentVersionRow;
    //! When downloading button data from DB.
    int buttonData;
    //! List for button ids.
    QStringList dbButtonIdsList;
    //! When downloading button ids from DB.
    int themeButtonIds;
    //! Method to get theme button datas by ids.
    void getThemeButtonsByIds();
    //! Helping variable to get all theme button datas.
    int themeButtonIndex;
    //! Some button data.
    QString buttonPath;
    QString  unpressedHash;
    QString  pressedHash;
    //! Method to get unpressed image of button.
    void getUnpressedImage();
    //! Method to get pressed image of button.
    void getPressedImage();
    //! Helping variables to call button downloading from DB.
    int unpressedToFile;
    int pressedToFile;
    //! List contains background ids.
    QStringList dbBackgroundIdsList;
    //! Some helping variables to get every background ids.
    int themeBgIndex;
    int themeBgIds;
    //! Method for getting backgound data by id.
    void getThemeBackgroundsByIds();
    //! Some background data.
    QString bgPath;
    QString  bgHash;
    //! Method to get background image.
    void getBgImage();
    //! Helping variables for background calls.
    int bgData;
    int bgToFile;
    //! Variable used when downloading theme.
    int downloadId;
    //! Progress bar used when downloading or uploading theme.
    QProgressBar *progress;
    //! Value for progress bar.
    int progressValue;

    //! Variables for theme data
    QString themeAuthor;
    QString themeNameFromConf;
    QString themeComments;
    QString themePreviewButton;
    QString themeVersion;

    QString tName;
    QString themeToDelete;
    QString readVersion(QString line);
    bool versionFound;
    bool ownTheme;
    //! Theme uploading
    void createNewTheme();
    int uploadTheme;
    int themeIdToUpload;
    QString uploadThemeName;
    QString uploadComments;
    QString uploadPreviewName;
    void uploadThemeButton();
    QString themeToUploadDir;
    int uploadButtonIndex;
    void readButtonConf(QString line);
    QString uploadButtonName;
    bool uploadAllowText;
    QString uploadTextFormatUp;
    QString uploadTextFormatDown;
    int addButtonToTheme;
    QString uploadUserName;
    QString uploadPwHash;

    //! Background  uploading
    void uploadThemeBg();
    int uploadBgIndex;
    int addBgToTheme;
    QString uploadBgName;
    void readBgConf(QString line);

    int setThemeDownloadable;
    int progressItemCount;
    int uploadItemsCount;



private slots:
    void on_deletePushButton_clicked();
    void on_downloadPushButton_clicked();
    void on_newPushButton_clicked();
    void updateListWidget(QListWidgetItem *item);
    void loadThemes();
    void processReturnValue(int Id,QVariant data);
    void error(int i,QString string);
    void fault(int i,int j,QString string);
    //! Slot to set current version string and update theme data.
    void themeVersionChanged(QString version);
    //! Slot to set current version row.
    void themeVersionChanged(int clickedRow);
    //! Slot for deleting theme.
    void deleteTheme();
    //! Slot for replacing existing theme.
    void replaceTheme();
    //! Slot for starting upload.
    void startUpload(QString user, QString pw);
    //! Slot for clearing used variables.
    void clearAllData();
signals:
    //! Signal for progressbar to delete self.
    void themeLoaded();
    //! Progressbars signal to change value.
    void progressState(int state);
    //! Signal for progressbar.
    void themeUploaded();
    //void startingDownload();
};
#endif // THEMEMANAGER_H
