#include "remotestartupdlg.h"
#include "ui_remotestartupdlg.h"

RemoteStartupDlg::RemoteStartupDlg(QString aRemoteName, QWidget *parent, QStringList *remotes) :
    QDialog(parent),
    m_ui(new Ui::RemoteStartupDlg)
{
    m_ui->setupUi(this);
    remoteNames = remotes;
    this->setWindowTitle("Select buttons for remote");
    flag = false;
    raw_flag = false;
    remoteName = aRemoteName;
    QDir dir;
    homePath = dir.currentPath();
    loadRemote();

    connect(m_ui->addedButtonslistWidget,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(removeFromSelectedList(QListWidgetItem*)));
    connect(m_ui->buttonlistWidget,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(itemClicked(QListWidgetItem*)));
}

RemoteStartupDlg::~RemoteStartupDlg()
{
    delete m_ui;
}

void RemoteStartupDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void RemoteStartupDlg::process_line(QString line)
{
    if(!line.startsWith("#",Qt::CaseInsensitive)) {
        if(line.contains("end codes", Qt::CaseInsensitive)) {
               flag = false;
               this->makeButtons();
            }

        if(line.contains("end raw_codes", Qt::CaseInsensitive)) {
               flag = false;
               this->makeButtons();
            }
        if(flag) {
            QString buttonName = line;
            int lineLength;
            QString finalButtonName;

            buttonName = buttonName.trimmed();
            lineLength = buttonName.length();

            for (int i=0;i<lineLength;i++) {
                if(buttonName.at(i).isSpace() == false)
                     finalButtonName.append(buttonName.at(i));

                 if(buttonName.at(i).isSpace() == true)
                     break;
            }
            buttonNames.append(finalButtonName);
        }
        if(raw_flag) {
             if(line.contains("name", Qt::CaseInsensitive)) {
                line = line.trimmed();
                line.remove(0,5);
                buttonNames.append(line);
             }
        }
        if(line.contains("begin codes", Qt::CaseInsensitive))
            flag = true;

        if(line.contains("begin raw_codes", Qt::CaseInsensitive))
            raw_flag = true;

    }
}

void RemoteStartupDlg::loadRemote()
{
    m_ui->remoteNameLineEdit->setText(remoteName);

    QFile file("/home/user/MyDocs/qtirreco/Devices/" + remoteName);
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
    return;

    QTextStream in(&file);
    while (!in.atEnd()) {
        QString line = in.readLine();
        process_line(line);
    }
    QDir dir;
    dir.setCurrent(homePath);
}

void RemoteStartupDlg::itemClicked(QListWidgetItem* item)
{
    addedButtonsCount = m_ui->addedButtonslistWidget->count();
    m_ui->addedButtonslistWidget->insertItem(addedButtonsCount, item->text());
    delete m_ui->buttonlistWidget->currentItem();
    addedButtonsCount = m_ui->addedButtonslistWidget->count();
}

void RemoteStartupDlg::removeFromSelectedList(QListWidgetItem* item)
{
     buttonsCount = m_ui->buttonlistWidget->count();
     m_ui->buttonlistWidget->insertItem(buttonsCount, item->text());
     m_ui->buttonlistWidget->sortItems(Qt::AscendingOrder);
     delete m_ui->addedButtonslistWidget->currentItem();
     buttonsCount = m_ui->buttonlistWidget->count();
}

void RemoteStartupDlg::makeButtons()
{
    m_ui->buttonlistWidget->insertItems(0, buttonNames);
    m_ui->buttonlistWidget->sortItems(Qt::AscendingOrder);
}

void RemoteStartupDlg::on_pushButton_clicked()
{
    bool sameName = false;
    if(!remoteNames->isEmpty() && !m_ui->remoteNameLineEdit->text().isEmpty()) {

          for(int i=0; i<remoteNames->count(); i++) {
              QString name = remoteNames->at(i);
              name.chop(5);
              if(name == m_ui->remoteNameLineEdit->text()) {
                  sameName = true;
                  QMessageBox::warning(this,"Remote name already exists!","Cannot create remote with existing name.",
                  QMessageBox::NoButton,QMessageBox::NoButton);
              }
          }
      }

    if(!sameName && !m_ui->remoteNameLineEdit->text().isEmpty()) {

        emit lwClear();
        if(m_ui->addedButtonslistWidget->count() > 0) {
            QString buttonTextToEmit;
            QStringList aCommand;
            for(int i = 0; i < addedButtonsCount ; i++) {
                buttonTextToEmit = m_ui->addedButtonslistWidget->item(i)->text();
                aCommand.append(remoteName + " " +  m_ui->addedButtonslistWidget->item(i)->text());
                emit addButtonToLayoutSignalFromRSD(buttonTextToEmit, buttonTextToEmit, buttonTextToEmit, buttonTextToEmit, aCommand, i);
                aCommand.clear();
            }
        }
        emit remoteCreated(m_ui->remoteNameLineEdit->text());
        this->close();
    }

}
