#include "createbuttondlg.h"
#include "ui_createbuttondlg.h"

CreateButtonDlg::CreateButtonDlg(QWidget *parent,QVector <ThemeCreatorButton*> *buttonsVector) :
    QDialog(parent),
    m_ui(new Ui::CreateButtonDlg)
{
    m_ui->setupUi(this);
    buttons = new QVector<ThemeCreatorButton*>();
    buttons = buttonsVector;
    m_ui->addPushButton->setDisabled(true);
    m_ui->pressedPushButton->setDisabled(true);
    m_ui->txtDownPushButton->setDisabled(true);
    m_ui->txtUpPushButton->setDisabled(true);
    m_ui->txtUpLineEdit->setDisabled(true);
    m_ui->txtDownLineEdit->setDisabled(true);
    this->setWindowTitle("Create a button");
    enablePressed = false;
    enableFont = false;

    this->createList();

    connect(m_ui->allowPushButton,SIGNAL(clicked()),this,SLOT(allowPushButton_clicked()));
    edit = false;
}
CreateButtonDlg::CreateButtonDlg(QWidget *parent,ThemeCreatorButton *button,QVector <ThemeCreatorButton*> *buttonsVector) :
    QDialog(parent),
    m_ui(new Ui::CreateButtonDlg)
{
    m_ui->setupUi(this);
    buttons = new QVector<ThemeCreatorButton*>();
    buttons = buttonsVector;
    b = new ThemeCreatorButton();
    b = button;
    connect(m_ui->allowPushButton,SIGNAL(clicked()),this,SLOT(allowPushButton_clicked()));
    connect(m_ui->addPushButton,SIGNAL(clicked()),this,SLOT(addButtonClicked()));
    this->setWindowTitle("Edit button");
    enablePressed = true;
    enableFont = true;
    enableFont = button->enableFont;
    fileNameUp = button->unpressedPath;
    fileNameDown = button->pressedPath;
    unpressedPix = button->unpressedPix;
    pressedPix = button->pressedPix;

    m_ui->unpressedLabel->setPixmap(button->unpressedPix.scaled(128,128,Qt::KeepAspectRatio,Qt::FastTransformation));
    m_ui->pressedLabel->setPixmap(button->pressedPix.scaled(128,128,Qt::KeepAspectRatio,Qt::FastTransformation));

    this->createList();

    edit = true;

    m_ui->nameComboBox->setEditText(button->buttonName);
    if(button->enableFont) {
        m_ui->allowPushButton->setText("Yes");
        m_ui->txtUpLineEdit->setFont(button->unpressedFont);
        m_ui->txtUpLineEdit->setText("abc123");
        m_ui->txtDownLineEdit->setFont(button->pressedFont);
        m_ui->txtDownLineEdit->setText("abc123");
    }
    else {
        m_ui->allowPushButton->setText("No");
        m_ui->txtUpLineEdit->setDisabled(true);
        m_ui->txtDownLineEdit->setDisabled(true);

    }
}
CreateButtonDlg::~CreateButtonDlg()
{
    delete m_ui;
}

void CreateButtonDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
void CreateButtonDlg::createList()
{
    QStringList *list = new QStringList();
    list->append("Blank");
    list->append("Down");
    list->append("Left");
    list->append("Next");
    list->append("Pause");
    list->append("Play");
    list->append("Play/Pause");
    list->append("Power");
    list->append("Prev");
    list->append("Right");
    list->append("Up");
    list->append("Menu");
    list->append("OK");
    list->append("EPG");
    list->append("Guide");
    list->append("Info");
    list->append("Red");
    list->append("Green");
    list->append("Yellow");
    list->append("Blue");
    list->append("Number 0");
    list->append("Number 1");
    list->append("Number 2");
    list->append("Number 3");
    list->append("Number 4");
    list->append("Number 5");
    list->append("Number 6");
    list->append("Number 7");
    list->append("Number 8");
    list->append("Number 9");
    m_ui->nameComboBox->clear();
    m_ui->nameComboBox->addItems(*list);
    delete list;
}
void CreateButtonDlg::setAddButtonText(QString text)
{
    m_ui->addPushButton->setText(text);
}
void CreateButtonDlg::on_unpressedPushButton_clicked()
{
    fileNameUp = QFileDialog::getOpenFileName(this, tr("Open Image"), "/home/user/MyDocs/qtirreco/themes/", tr("Image Files (*.png)"));
    QPixmap pix(fileNameUp);
    if(!pix.isNull()) {
        m_ui->pressedPushButton->setEnabled(true);
        enablePressed = true;
        unpressedPix = pix;
        pix = pix.scaled(128,128,Qt::IgnoreAspectRatio,Qt::FastTransformation);
        m_ui->unpressedLabel->setPixmap(pix);
    }
}

void CreateButtonDlg::on_pressedPushButton_clicked()
{

    fileNameDown = QFileDialog::getOpenFileName(this, tr("Open Image"), "/home/user/MyDocs/qtirreco/themes/", tr("Image Files (*.png)"));
    QPixmap pix(fileNameDown);
    if(!pix.isNull()) {
        m_ui->addPushButton->setEnabled(true);
        connect(m_ui->addPushButton,SIGNAL(clicked()),this,SLOT(addButtonClicked()));
        pressedPix = pix;
        pix = pix.scaled(128,128,Qt::IgnoreAspectRatio,Qt::FastTransformation);
        m_ui->pressedLabel->setPixmap(pix);
    }
}
void CreateButtonDlg::addButtonClicked()
{
    if(!edit && !m_ui->nameComboBox->currentText().isEmpty()) {
        for(int i=0;i<buttons->count();i++) {
            if(buttons->at(i)->buttonName == m_ui->nameComboBox->currentText()) {
                QMessageBox::warning(this,"Button name already exists!","Please choose a different button name.",
                                  QMessageBox::NoButton,QMessageBox::NoButton);
                return;
            }
        }
        emit createButton(m_ui->nameComboBox->currentText(),pressedPix,unpressedPix,pressedFont,unpressedFont,enableFont,fileNameDown,fileNameUp);
        this->close();
    }
    if(edit && !m_ui->nameComboBox->currentText().isEmpty()) {
        for(int i=0;i<buttons->count();i++) {
            if(buttons->at(i)->buttonName == m_ui->nameComboBox->currentText() && m_ui->nameComboBox->currentText() != b->buttonName) {
                QMessageBox::warning(this,"Button name already exists!","Please choose a different button name.",
                                  QMessageBox::NoButton,QMessageBox::NoButton);
                return;
            }
        }
        emit createButton(m_ui->nameComboBox->currentText(),pressedPix,unpressedPix,pressedFont,unpressedFont,enableFont,fileNameDown,fileNameUp);
        this->close();
    }
}
void CreateButtonDlg::mousePressEvent(QMouseEvent *event)
{
    if(event->pos().x() >= m_ui->unpressedLabel->pos().x() && event->pos().x() <= m_ui->unpressedLabel->pos().x() + m_ui->unpressedLabel->width()
        && event->pos().y() >= m_ui->unpressedLabel->pos().y() && event->pos().y() <= m_ui->unpressedLabel->pos().y() + m_ui->unpressedLabel->height()
        && m_ui->tabWidget->currentIndex() == 0)
            on_unpressedPushButton_clicked();

    if(event->pos().x() >= m_ui->pressedLabel->pos().x() && event->pos().x() <= m_ui->pressedLabel->pos().x() + m_ui->pressedLabel->width()
        && event->pos().y() >= m_ui->pressedLabel->pos().y() && event->pos().y() <= m_ui->pressedLabel->pos().y() + m_ui->pressedLabel->height()
        && enablePressed == true && m_ui->tabWidget->currentIndex() == 0)
            on_pressedPushButton_clicked();
}

void CreateButtonDlg::on_txtUpPushButton_clicked()
{
    bool ok;
    QFont font = QFontDialog::getFont(&ok,QFont("sans-serif",10),this);
    if(ok) {
        m_ui->txtUpLineEdit->setFont(font);
        unpressedFont = font;
        m_ui->txtUpLineEdit->setText("abc123");
    }
}

void CreateButtonDlg::on_txtDownPushButton_clicked()
{
    bool ok;
    QFont font = QFontDialog::getFont(&ok,QFont("sans-serif",10),this);
    if(ok) {
        m_ui->txtDownLineEdit->setFont(font);
        pressedFont = font;
        m_ui->txtDownLineEdit->setText("abc123");
    }
}

void CreateButtonDlg::allowPushButton_clicked()
{
    switch(enableFont) {
    case true:
        m_ui->allowPushButton->setText("No");
        m_ui->allowPushButton->update(m_ui->allowPushButton->rect());
        m_ui->txtUpLineEdit->setText("");
        m_ui->txtUpLineEdit->setDisabled(true);
        m_ui->txtUpLineEdit->update(m_ui->txtUpLineEdit->rect());
        m_ui->txtDownLineEdit->setText("");
        m_ui->txtDownLineEdit->setDisabled(true);
        m_ui->txtDownLineEdit->update(m_ui->txtDownLineEdit->rect());
        m_ui->txtDownPushButton->setDisabled(true);
        m_ui->txtDownPushButton->update(m_ui->txtDownPushButton->rect());
        m_ui->txtUpPushButton->setDisabled(true);
        m_ui->txtUpPushButton->update(m_ui->txtUpPushButton->rect());
        enableFont = false;
        break;
    case false:
        m_ui->allowPushButton->setText("Yes");
        m_ui->allowPushButton->update(m_ui->allowPushButton->rect());
        m_ui->txtUpLineEdit->setText("abc123");
        m_ui->txtUpLineEdit->setEnabled(true);
        m_ui->txtUpLineEdit->update(m_ui->txtUpLineEdit->rect());
        m_ui->txtDownLineEdit->setText("abc123");
        m_ui->txtDownLineEdit->setEnabled(true);
        m_ui->txtDownLineEdit->update(m_ui->txtDownLineEdit->rect());
        m_ui->txtUpPushButton->setEnabled(true);
        m_ui->txtUpPushButton->update(m_ui->txtUpPushButton->rect());
        m_ui->txtDownPushButton->setEnabled(true);
        m_ui->txtDownPushButton->update(m_ui->txtDownPushButton->rect());
        enableFont = true;
        break;
    }
}
