#ifndef BACKGROUNDCOLORDLG_H
#define BACKGROUNDCOLORDLG_H

#include <QtGui/QDialog>

namespace Ui {
    class BackgroundColorDlg;
}

class BackgroundColorDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(BackgroundColorDlg)
public:
    //! Constructor.
    explicit BackgroundColorDlg(QWidget *parent = 0);
    //! Destructor.
    virtual ~BackgroundColorDlg();
    //! Integer values of red,green and blue from scrollbars.
    int r,g,b;

protected:
    virtual void changeEvent(QEvent *e);

private:
    Ui::BackgroundColorDlg *m_ui;

private slots:
    //! Slot for setting label pixmap.
    void setPreviewPalette();
    //! Slot for emitting signals.
    void on_selectColorButton_clicked();

signals:
    //! When select clicked, emits backgroundcolor to BackgroundDialog class.
    void selectClicked(QColor bgc);
    //! When select clicked, emits backgroundcolor RGB values to BackgroundDialog class.
    void rgbValues(QString red,QString green,QString blue);
};
#endif // BACKGROUNDCOLORDLG_H
