/* --------------------------------------------------------------------------------------------
Copyright 2009 Robin Nilsson <robinnilsson@gmail.com>. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are
permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, this list of
      conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above copyright notice, this list
      of conditions and the following disclaimer in the documentation and/or other materials
      provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Robin Nilsson ``AS IS'' AND ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL Robin Nilsson OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those of the
authors and should not be interpreted as representing official policies, either expressed
or implied, of Robin Nilsson.
------------------------------------------------------------------------------------------- */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTreeWidgetItem>
#include "despotifywrap.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::MainWindow *ui;
    DespotifyWrap *dw;
    int song_tot_len;
    void PrintTracksPlaylist();
    void PrintTracksSearch();
    void PrintTracksAlbum();
    void ShowAlbum(track *t,int offset);

    /* For time-telling redraw filter */
    int last_sec;

private slots:
    /* Ui related */
    void on_pbHideAlbumart_clicked();
    void on_cbSave_clicked(bool checked);
    void on_twAlbum_itemClicked(QTreeWidgetItem* item, int column);
    void on_twPlaylist_itemClicked(QTreeWidgetItem* item, int column);
    void on_actAlbum_triggered();
    void on_actSearch_triggered();
    void on_actPlaylist_triggered();
    void on_twSearch_itemClicked(QTreeWidgetItem* item, int column);
    void on_actionTest_triggered();
    void on_actionPlaylist_triggered();
    void on_pbSearch_clicked();
    void on_twSongs_itemClicked(QTreeWidgetItem* item, int column);
    void on_leSearch_returnPressed();
    void on_pushButton_clicked();
    void on_pushButton_3_clicked();
    void on_pushButton_4_clicked();
    void on_cbPlaylists_currentIndexChanged(int index);
    void on_pbLogin_clicked();


    /* Despotify-wrapper related */
    void PlaylistsUpdated();
    void EndOfPlaylist();
    void NewTrack(int min, int sec, int totsec, track *t);
    void TellTime(int min, int sec, int totsec);


    /* Player related */
    void Playing();
    void Paused();
    void Exiting();

};



#endif // MAINWINDOW_H
