#include <QDebug>

#include "audio.h"

ao_device* audio_init(void)
{
    ao_device *device;
    ao_sample_format format;
    int default_driver;
    ao_initialize ();
    default_driver = ao_default_driver_id ();
    format.bits = 16;
    format.rate = 44100;
    format.channels = 2;
    format.byte_format = AO_FMT_LITTLE;
    device = ao_open_live (default_driver, &format, NULL);
    if (!device) {
        qDebug() << "audio_init() failed\n";
        return NULL;
    }

    return device;
}

int audio_exit (void* device)
{
    if (ao_close ((ao_device*)device) == 0) {
        qDebug() << "ao_close() failed\n";
        return -1;
    }

    ao_shutdown ();

    return 0;
}

int audio_play_pcm (void* device, struct pcm_data* pcm)
{
    if (ao_play ((ao_device*)device, pcm->buf, pcm->len) == 0) {
        qDebug() << "ao_play() failed\n";
        return -1;
    }

    return 0;
}
