#include "settings.h"
#include "ui_settings.h"
#include <QtGui>
#include <QSqlQuery>
#include <QListWidgetItem>

bool bshowLang1;
bool bshowLang2;
bool bshowLang3;
bool bshowLang4;
int sortBy;
int selectBy;
int iLessonID;



Settings::Settings(QWidget *parent)
     : QDialog(parent)//, ui(new Ui::Settings)
{
    setupUi(this);

    scrollArea->setProperty("FingerScrollable", true);
    scrollArea->setWidgetResizable(true);
    QButtonGroup btngSelection;
    QButtonGroup btngOrder;
}

bool Settings::showLang1()
{
   return bshowLang1;
}

bool Settings::showLang2()
{
   return bshowLang2;
}
bool Settings::showLang3()
{
   return bshowLang3;
}
bool Settings::showLang4()
{
   return bshowLang4;
}

int Settings::selectBy()
{

    if (btngSelection->checkedButton()->text()== "All")
    {
        return 1;
    }
    else if (btngSelection->checkedButton()->text()== "Not Learned")
    {
        return 2;
    }
    else
    {
        return 0;
    }
}

int Settings::sortBy()
{
    if (btngOrder->checkedButton()->text()== "Random")
    {
        return 1;
    }
    else if (btngOrder->checkedButton()->text()== "Alphabetic")
    {
        return 2;
    }
    else if (btngOrder->checkedButton()->text()== "Difficulty")
    {
        return 3;
    }
    else //"Not learned"
    {
        return 0;
    }
}

void Settings::on_pbOK_clicked()
{
        bshowLang1 = checkBox->isChecked();
        bshowLang2 = checkBox_2->isChecked();
        bshowLang3 = checkBox_3->isChecked();
}

void Settings::on_lstCourse_activated(QString sCourseName)
{
    QSqlQuery qry;
//    QString sCourseName;
    int iCourseID = 1;

//    sCourseName = lstCourse->currentText();

    qry.prepare("SELECT rowid, showSide1, showSide2, showSide3, showSide4, "
                "sortBy, selectBy, "
                "side1 , side2, side3, side4 "
                "FROM courses "
                "WHERE name=:name");

    qDebug() << "sCourseName" << sCourseName;
    qry.bindValue(":name", sCourseName);
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
//        qDebug() << qry.lastError();
    }

    qry.next();
    iCourseID=qry.value(0).toInt();

    checkBox->setChecked(qry.value(1).toBool());
    checkBox_2->setChecked(qry.value(2).toBool());
    checkBox_3->setChecked(qry.value(3).toBool());
    checkBox->setText(qry.value(7).toString());
    qDebug() << qry.value(7).toString();
    checkBox_2->setText(qry.value(8).toString());
    qDebug() << qry.value(8).toString();
    checkBox_3->setText(qry.value(9).toString());
    qDebug() << qry.value(9).toString();
//    showLang4=qry.value(4).toInt();

    switch (qry.value(5).toInt()){
    case 0:
        break;
    case 1:
        radioButton_3->setChecked(true);
        break;
    case 2:
        radioButton_4->setChecked(true);
        break;
    case 3:
        radioButton_5->setChecked(true);
        break;
    }

    switch (qry.value(6).toInt()){
    case 0:
        break;
    case 1:
        radioButton->setChecked(true);
        break;
    case 2:
        radioButton_2->setChecked(true);
        break;
    }

    qry.prepare("SELECT * "
                "FROM chapters "
                "WHERE courseid=:courseid");

    qDebug() << iCourseID;
    qry.bindValue(":courseid", iCourseID);
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
//        qDebug() << qry.lastError();
    }

    qDebug() << qry.numRowsAffected();
    qry.next();
    listChapter->clear();
    while (qry.isValid())
    {
        qDebug() << qry.value(0);
        qDebug() << qry.value(1);
        qDebug() << qry.value(2);
        qDebug() << qry.value(3);
        listChapter->addItem(qry.value(0).toString());
        qry.next();
    }
}


//Settings::~Settings()
//{
//    delete ui;
//}

