#ifndef TODOMODEL_H
#define TODOMODEL_H

#include <QObject>
#include <QSqlError>
#include <QSqlDatabase>
#include <QStringList>
#include <QMap>

struct TaskEntry
{
    int id;
    QString desc;
    QString folder;
    int cat;
};

// manage int => string mappings in underlying database, + caching
class SqlMapping
{
public:

    typedef QMap< QString, int>  MapT;

    explicit SqlMapping(QSqlDatabase* db, const QString& tablename);

    MapT getAll();
    // return id of new item
    int addDesc(const QString& desc);
    int findId(const QString& desc);




    MapT m_cache;

private:

    QSqlDatabase* m_db;
    QString m_tablename;
};


class TodoModel : public QObject
{
Q_OBJECT

private:
    explicit TodoModel(QObject *parent = 0);
public:

    // "TABLE", "fields", "TABLE2", field...
    void describeTables(const QStringList& tabledesc);
    bool openDB();
    QSqlError lastError();
    bool deleteDB();

    void getTasksForFolder(const QString& foldername, QList<TaskEntry>& tasks);
    void createTask(const QString& task, const QString& folder);
    bool createTables();

    void commitTask(TaskEntry& tent);
    void doEmitUpdated(const QString& folder);
    TaskEntry findById(int id);

    static TodoModel* instance();
    int countItems(const QString& folder);
    void countAllFolders();

    QStringList allFolders();
    void deleteTask(TaskEntry& tent);

    void listCategories(QStringList& cats);


    QString currentCategory();
    int currentCategoryId();
    void createCategory(const QString& cat);


    QString windowTitle(const QString& prefix);

signals:
    void updatedFolder(const QString& foldername);

    // emitted when folder has been changed & size counted
    void folderSizeReport(const QString& foldername, int itemcount);


public slots:
    void setCurrentCategory(const QString& category);

private:

    static TodoModel* sm_instance;
    QStringList m_tabledesc;

    SqlMapping* m_catmapping;

    QString m_currentCategory;
    int m_currentCategoryId;

    QSqlDatabase db;

};

#endif // TODOMODEL_H
