#include "ui_frontpage.h"
#include "frontpage.h"

#include <QSignalMapper>

#include <QDebug>
#include "folderview.h"
#include "todomodel.h"
#include "taskeditor.h"

#include <QMaemo5ValueButton>
#include <QTimer>
#include <QWidget>
#include <QWidgetAction>
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include <QStandardItemModel>
#include "filterselectoraction.h"
#include "platutil.h"

class FilterAction : public QWidgetAction
{
public:
    FilterAction(QObject* parent) : QWidgetAction(parent) {

    };

    QWidget* createWidget(QWidget* parent) {

        QMaemo5ValueButton* b = new QMaemo5ValueButton(parent);
        b->setText("Filter");;
        b->setValueText("Val");

        return b;
    }


};

FrontPage::FrontPage(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::FrontPage)
{

    PlatUtil::configureWindow(this);
    //m_catselector = new
    TodoModel* mdl = TodoModel::instance();
    ui->setupUi(this);
    connect(ui->addBtn, SIGNAL(clicked()), this, SLOT(addClicked()));
    connect(ui->lineEdit, SIGNAL(returnPressed()), this, SLOT(addClicked()));
    connect(ui->inboxListWidget, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(itemSelected(QListWidgetItem*)));
    connect(mdl, SIGNAL(updatedFolder(QString)), this, SLOT(folderUpdated(QString)));
    connect(mdl, SIGNAL(folderSizeReport(QString,int)), this, SLOT(folderSizeUpdated(QString,int)));

    CategorySelectorAction* filt = new CategorySelectorAction(this);

    menuBar()->addAction(filt);
    setWindowTitle("Qtdone - INBOX");

    createFolderLinks(ui->frame);
    populate();

}

FrontPage::~FrontPage()
{
    delete ui;
}

void FrontPage::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void FrontPage::addClicked()
{
    QString txt = ui->lineEdit->text();

    // cheat - show item before doing full repopulation
    ui->inboxListWidget->addItem(txt);
    ui->lineEdit->clear();
    ui->lineEdit->setFocus();

    TodoModel::instance()->createTask(txt, "inbox");
    QTimer::singleShot(0, this, SLOT(populate()));
}


void FrontPage::folderSelector(const QString& folder)
{
    qDebug() << "Selector" << folder;
    FolderView* fv = m_folders[folder];
    fv->populate();
    fv->show();
}

void FrontPage::createFolderLinks(QWidget* wdg)
{
    QHBoxLayout* hl = new QHBoxLayout(wdg);

    QSignalMapper* mapper = new QSignalMapper(this);
    connect(mapper, SIGNAL(mapped(QString)), this, SLOT(folderSelector(QString)));

    TodoModel* m = TodoModel::instance();
    QStringList folders = m->allFolders();

    foreach (const QString& s, folders) {

#ifdef Q_WS_MAEMO_5
        QMaemo5ValueButton* b = new QMaemo5ValueButton();

        b->setValueText("test");
#else
        QPushButton *b = new QPushButton();

#endif
        // valuebutton is subclass of pushbutton

        m_folderSelectors[s]= b;
        connect(b, SIGNAL(clicked()), mapper, SLOT(map()));
        //b->toggle();
        b->setText(s);
        wdg->setLayout(hl);
        mapper->setMapping(b, s );
        hl->addWidget(b);

        // create view for the folder

        FolderView* fw = new FolderView(this);
        fw->setName(s);
        m_folders[s] = fw;
    }

    foreach (const QString&s, folders) {
        m->countItems(s);
    }

}

void FrontPage::setModel(TodoModel *mdl)
{
    Q_UNUSED(mdl);
    //m_td = mdl;
}


void FrontPage::populate()
{
    QList<TaskEntry> tasks;
    TodoModel* m = TodoModel::instance();

    m->getTasksForFolder("inbox", tasks);

    if (tasks.isEmpty()) {
        m->getTasksForFolder("Now", tasks);
        setWindowTitle(m->windowTitle("Qtd Now"));
    } else {
        setWindowTitle(m->windowTitle("Qtd In"));
    }

    ui->inboxListWidget->clear();
    foreach (const TaskEntry& t, tasks) {
        QListWidgetItem* it = new QListWidgetItem(t.desc);

        it->setData(Qt::UserRole, t.id);
        ui->inboxListWidget->addItem(it);
    }
}

void FrontPage::itemSelected(QListWidgetItem *item)
{
    int iid = item->data(Qt::UserRole).toInt();

    qDebug() << "Selected" << iid;


    TaskEntry t = TodoModel::instance()->findById(iid);

    TaskEditor* te = new TaskEditor(t, this);

    te->show();
}

void FrontPage::folderUpdated(const QString &folder)
{
    if (folder == "inbox") {
        populate();
    }
}

void FrontPage::folderSizeUpdated(const QString &folder, int newcount)
{
#ifdef Q_WS_MAEMO_5
    QPushButton* b = m_folderSelectors[folder];

    if (QMaemo5ValueButton* vb = qobject_cast<QMaemo5ValueButton*>(b)) {
        vb->setValueText(QString::number(newcount));
    }

#endif

}
