/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLParamElement.h"

#include <wtf/GetPtr.h>

#include "HTMLParamElement.h"
#include "KURL.h"

#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLParamElement)

/* Hash table */

static const HashTableValue JSHTMLParamElementTableValues[6] =
{
    { "name", DontDelete, (intptr_t)jsHTMLParamElementName, (intptr_t)setJSHTMLParamElementName },
    { "type", DontDelete, (intptr_t)jsHTMLParamElementType, (intptr_t)setJSHTMLParamElementType },
    { "value", DontDelete, (intptr_t)jsHTMLParamElementValue, (intptr_t)setJSHTMLParamElementValue },
    { "valueType", DontDelete, (intptr_t)jsHTMLParamElementValueType, (intptr_t)setJSHTMLParamElementValueType },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLParamElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLParamElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSHTMLParamElementTableValues, 0 };
#else
    { 18, 15, JSHTMLParamElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLParamElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLParamElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLParamElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLParamElementConstructorTableValues, 0 };
#endif

class JSHTMLParamElementConstructor : public DOMObject {
public:
    JSHTMLParamElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLParamElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLParamElementPrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLParamElementConstructor::s_info = { "HTMLParamElementConstructor", 0, &JSHTMLParamElementConstructorTable, 0 };

bool JSHTMLParamElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLParamElementConstructor, DOMObject>(exec, &JSHTMLParamElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLParamElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLParamElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLParamElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLParamElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLParamElementPrototype::s_info = { "HTMLParamElementPrototype", 0, &JSHTMLParamElementPrototypeTable, 0 };

JSObject* JSHTMLParamElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLParamElement>(exec, globalObject);
}

const ClassInfo JSHTMLParamElement::s_info = { "HTMLParamElement", &JSHTMLElement::s_info, &JSHTMLParamElementTable, 0 };

JSHTMLParamElement::JSHTMLParamElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLParamElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLParamElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLParamElementPrototype(JSHTMLParamElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLParamElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLParamElement, Base>(exec, &JSHTMLParamElementTable, this, propertyName, slot);
}

JSValuePtr jsHTMLParamElementName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLParamElement* imp = static_cast<HTMLParamElement*>(static_cast<JSHTMLParamElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->name());
}

JSValuePtr jsHTMLParamElementType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLParamElement* imp = static_cast<HTMLParamElement*>(static_cast<JSHTMLParamElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->type());
}

JSValuePtr jsHTMLParamElementValue(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLParamElement* imp = static_cast<HTMLParamElement*>(static_cast<JSHTMLParamElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->value());
}

JSValuePtr jsHTMLParamElementValueType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLParamElement* imp = static_cast<HTMLParamElement*>(static_cast<JSHTMLParamElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->valueType());
}

JSValuePtr jsHTMLParamElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLParamElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLParamElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLParamElement, Base>(exec, propertyName, value, &JSHTMLParamElementTable, this, slot);
}

void setJSHTMLParamElementName(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLParamElement* imp = static_cast<HTMLParamElement*>(static_cast<JSHTMLParamElement*>(thisObject)->impl());
    imp->setName(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLParamElementType(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLParamElement* imp = static_cast<HTMLParamElement*>(static_cast<JSHTMLParamElement*>(thisObject)->impl());
    imp->setType(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLParamElementValue(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLParamElement* imp = static_cast<HTMLParamElement*>(static_cast<JSHTMLParamElement*>(thisObject)->impl());
    imp->setValue(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLParamElementValueType(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLParamElement* imp = static_cast<HTMLParamElement*>(static_cast<JSHTMLParamElement*>(thisObject)->impl());
    imp->setValueType(valueToStringWithNullCheck(exec, value));
}

JSValuePtr JSHTMLParamElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLParamElementConstructor>(exec);
}


}
