/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QtGui>
#include <QtDBus>
#include <QtMaemo5>

// ![0]
#include <mce/mode-names.h>
#include <mce/dbus-names.h>
// ![0]

class RotationAwareWidget : public QWidget
{
    Q_OBJECT

public:
    RotationAwareWidget()
    {
// ![1]
        QDBusConnection::systemBus().connect(QString(), MCE_SIGNAL_PATH, MCE_SIGNAL_IF,
               MCE_DEVICE_ORIENTATION_SIG,
               this,
               SLOT(orientationChanged(QString)));
// ![1]

        QVBoxLayout *layout = new QVBoxLayout(this);
        label = new QLabel;
        layout->addWidget(label);

        label->setText("<p align=\"center\">Rotate your device to switch modes</p>");
    }

    void setLandscape()
    {
// ![2]
        setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
// ![2]

        label->setText("<p align=\"center\">In landscape mode now</p>");
    }

    void setPortrait()
    {
// ![3]
        setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
// ![3]

        label->setText("<p align=\"center\">In portrait mode now</p>");
    }

public slots:
// ![4]
    void orientationChanged(const QString &newOrientation)
    {
        if (newOrientation == QLatin1String(MCE_ORIENTATION_PORTRAIT))
            setPortrait();
        else
            setLandscape();
    }
// ![4]

protected:
// ![5]
    bool event(QEvent *ev)
    {
        switch (ev->type()) {
        case QEvent::WindowActivate:
            QDBusConnection::systemBus().call(
                QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH,
                                               MCE_REQUEST_IF,
                                               MCE_ACCELEROMETER_ENABLE_REQ));
            break;
        case QEvent::WindowDeactivate:
            QDBusConnection::systemBus().call(
                QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH,
                                               MCE_REQUEST_IF,
                                               MCE_ACCELEROMETER_DISABLE_REQ));
            break;
        default:
            break;
        }

        return QWidget::event(ev);
    }
// ![5]

private:
    QLabel *label;
};

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    RotationAwareWidget w;
    w.show();

    return app.exec();
}

#include "main.moc"
