/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QDialog>
#include <QLayout>
#include <QListWidget>
#include <QTime>
#include <QAbstractButton>
#include <QDialogButtonBox>
#include <QGtkStyle>

#include <qmaemo5timepickselector.h>
#include <private/qmaemo5timepickselector_p.h>


QT_BEGIN_NAMESPACE


static bool isSystemAmPm()
{
    return !QGtkStyle::getGConfBool(QLatin1String("/apps/clock/time-format"), true);
}


QMaemo5TimePickSelector::QMaemo5TimePickSelector(QObject *parent)
    : QMaemo5AbstractPickSelector(*new QMaemo5TimePickSelectorPrivate, parent)
{
    Q_D(QMaemo5TimePickSelector);
    d->init();
}

QMaemo5TimePickSelector::QMaemo5TimePickSelector(QMaemo5TimePickSelectorPrivate &dd, QObject *parent)
    : QMaemo5AbstractPickSelector(dd, parent)
{
    Q_D(QMaemo5TimePickSelector);
    d->init();
}

QMaemo5TimePickSelector::~QMaemo5TimePickSelector()
{
}

QTime QMaemo5TimePickSelector::currentTime() const
{
    Q_D(const QMaemo5TimePickSelector);
    return d->time;
}

void QMaemo5TimePickSelector::setCurrentTime(const QTime &time)
{
    Q_D(QMaemo5TimePickSelector);
    d->time = time;
}

int QMaemo5TimePickSelector::minuteStep() const
{
    Q_D(const QMaemo5TimePickSelector);
    return d->minuteStep;
}

void QMaemo5TimePickSelector::setMinuteStep(int step)
{
    Q_D(QMaemo5TimePickSelector);
    d->minuteStep = step;
}

void QMaemo5TimePickSelectorPrivate::emitSelected(const QVariant &var, const QString &str)
{
    Q_Q(QMaemo5TimePickSelector);
    emit q->selected(var, str);
}

class TimeDialog : public QDialog {
public:
    TimeDialog(QMaemo5TimePickSelectorPrivate *picker, QWidget *parent)
        : QDialog(parent), timePickSelectorPrivate(picker)
    { }
    
    void accept()
    {
        if (timePickSelectorPrivate && hours->currentItem() && minutes->currentItem()) {
            int hh = 0, mm = 0;
            
            if (hours->currentItem())
                hh = hours->currentItem()->text().toInt();
            if (minutes->currentItem())
                mm = minutes->currentItem()->text().toInt();
            if (ampm->isVisible() && ampm->currentItem()) {
                if (hh > 11)
                    hh -= 12;
                if (ampm->currentItem()->text() == QLocale::system().pmText())
                    hh += 12;
            }
            timePickSelectorPrivate->time.setHMS(hh, mm, 0);
            timePickSelectorPrivate->emitSelected(QVariant(timePickSelectorPrivate->time),
                timePickSelectorPrivate->time.toString(QLatin1String(ampm->isVisible() ? "h:mm ap" : "HH:mm")));
        }
        QDialog::accept();
    }
    
    QMaemo5TimePickSelectorPrivate *timePickSelectorPrivate;
    QListWidget *hours;
    QListWidget *minutes;
    QListWidget *ampm;
};

static void centerItems(QListWidget *lw)
{
    for (int i = 0; i < lw->count(); ++i)
        lw->item(i)->setTextAlignment(Qt::AlignCenter);
}

QWidget *QMaemo5TimePickSelector::widget(QWidget *parent)
{
    Q_D(QMaemo5TimePickSelector);

    TimeDialog *td = new TimeDialog(d, parent);
    if (QAbstractButton *pb = qobject_cast<QAbstractButton *>(parent))
        td->setWindowTitle(pb->text());
    td->setAttribute(Qt::WA_DeleteOnClose);
    QHBoxLayout *l = new QHBoxLayout(td);
    
    
    td->hours = new QListWidget();
    td->hours->setObjectName(QLatin1String("hours"));
    td->minutes = new QListWidget();
    td->minutes->setObjectName(QLatin1String("minutes"));
    td->ampm = new QListWidget();
    td->ampm->setObjectName(QLatin1String("ampm"));

    if (isSystemAmPm()) {
        td->hours->addItem(QString::number(12));
        for (int i = 1; i < 12; i++)
            td->hours->addItem(QString::number(i));
        td->ampm->addItem(QLocale::system().amText());
        td->ampm->addItem(QLocale::system().pmText());
        
        td->hours->setCurrentItem(td->hours->item(d->time.hour() % 12));
        td->ampm->setCurrentItem(td->ampm->item(d->time.hour() < 12 ? 0 : 1));
        centerItems(td->ampm);
    } else {
        for (int i = 0; i < 24; i++)
            td->hours->addItem(QString::fromLatin1("%1").arg(i, 2, 10, QLatin1Char('0')));
        td->ampm->hide();
        td->hours->setCurrentItem(td->hours->item(d->time.hour()));
    }        
    centerItems(td->hours);

    for (int i = 0; i < 60; i += d->minuteStep)
        td->minutes->addItem(QString::fromLatin1("%1").arg(i, 2, 10, QLatin1Char('0')));
    td->minutes->setCurrentItem(td->minutes->item(d->time.minute() / d->minuteStep));
    centerItems(td->minutes);

    QDialogButtonBox *box = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel, Qt::Vertical);
    
    l->addWidget(td->hours);
    l->addWidget(td->minutes);
    l->addWidget(td->ampm);
    l->addWidget(box, Qt::AlignBottom);
    
    connect(box, SIGNAL(accepted()), td, SLOT(accept()));
    connect(box, SIGNAL(rejected()), td, SLOT(reject()));

    td->hours->setMinimumHeight(td->hours->sizeHintForRow(0) * 5);    
    return td;
}


QVariant QMaemo5TimePickSelector::currentValue() const
{
    Q_D(const QMaemo5TimePickSelector);
    return QVariant(d->time);
}

QString QMaemo5TimePickSelector::currentValueAsText() const
{
    Q_D(const QMaemo5TimePickSelector);
    return d->time.toString(QLatin1String(isSystemAmPm() ? "h:mm ap" : "HH:mm"));
}

QT_END_NAMESPACE
