/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef S60AUDIOCAPTURESESSION_H
#define S60AUDIOCAPTURESESSION_H

#include <QFile>
#include <QUrl>

#include "s60audioencodercontrol.h"
#include "s60audioendpointselector.h"
#include "s60audiomediarecordercontrol.h"

#include <QAudioFormat>

#include <Mda\Common\Audio.h>
#include <Mda\Common\Resource.h>
#include <Mda\Client\Utility.h>
#include <MdaAudioSampleEditor.h>

struct ItemData
{
	int controllerUid;
	int destinationFormatUid;
	QString destinationFormatDescription;
};


class S60AudioCaptureSession : public QObject, public MMdaObjectStateChangeObserver
{
    Q_OBJECT

public:
    S60AudioCaptureSession(QObject *parent = 0);
    ~S60AudioCaptureSession();

    QAudioFormat format() const;
    bool isFormatSupported(const QAudioFormat &format) const;
    bool setFormat(const QAudioFormat &format);
    QStringList supportedAudioCodecs() const;
    QString codecDescription(const QString &codecName);
    bool setAudioCodec(const QString &codecName);
    QString audioCodec() const;

    QUrl outputLocation() const;
    bool setOutputLocation(const QUrl& sink);
    qint64 position() const;
    int state() const;
    void record();
    void pause();
    void stop();

public slots:
    void setCaptureDevice(const QString &deviceName);

signals:
    void stateChanged(QMediaRecorder::State state);
    void positionChanged(qint64 position);

private slots:
    void stateChanged(QAudio::State state);
    void notify();

private:
    enum TStatus
    {
        ENotReady,
        EOpen
    };
    
    void MoscoStateChangeEvent(CBase* aObject, TInt aPreviousState,
            TInt aCurrentState, TInt aErrorCode);
    void MoscoStateChangeEventL(CBase* aObject, TInt aPreviousState,
            TInt aCurrentState, TInt aErrorCode);
    
    void fetchAudioCodecsL();

    
    QString m_captureDevice;
    QUrl m_sink;
    QMediaRecorder::State m_state;
    
    CMdaAudioRecorderUtility *m_recorderUtility;
    QAudioFormat m_format;
    qint64 m_position;
    bool wavFile;
    
    QHash<QString, ItemData> m_controllerIdMap;
    
    // WAV header stuff

    struct chunk
    {
        char        id[4];
        quint32     size;
    };

    struct RIFFHeader
    {
        chunk       descriptor;
        char        type[4];
    };

    struct WAVEHeader
    {
        chunk       descriptor;
        quint16     audioFormat;        // PCM = 1
        quint16     numChannels;
        quint32     sampleRate;
        quint32     byteRate;
        quint16     blockAlign;
        quint16     bitsPerSample;
    };

    struct DATAHeader
    {
        chunk       descriptor;
        quint8      data[4];
    };

    struct CombinedHeader
    {
        RIFFHeader  riff;
        WAVEHeader  wave;
        DATAHeader  data;
    };

    CombinedHeader      header;
};

#endif // S60AUDIOCAPTURESESSION_H
