//ConnectionManager.h: Header file for the ConnectionManager class. The class handles operations / event notification related to connection state changes (such as e.g., roaming, offline / online state changes).
#ifndef CONNECTIONMANAGER_H
#define CONNECTIONMANAGER_H

#include <QObject>
#include <QNetworkConfigurationManager>
#include <QNetworkConfiguration>
#include <QNetworkSession>
#include <QtSystemInfo/QSystemNetworkInfo>

using namespace QtMobility;

class ConnectionManager : public QObject
{
    Q_OBJECT

public:

    ConnectionManager(QObject *pParent = 0);
    ~ConnectionManager();

    bool attemptConnect(); //Attempt to establish internet connection using default configuration. Return true on success; false on failure.

    bool currOnlineState(); //Return true if current state is online; otherwise returns false (offline)
    QNetworkConfiguration::BearerType bearerType(); //Return current bearer type (as enum)
    bool roamingSupported(); //Return true in case current bearer supports roaming

private:

    QNetworkConfigurationManager m_netConfMan; //network configuration manager instance

    QNetworkConfiguration m_activeNetConf; //active network configuration

    QNetworkSession*  m_pNetSess; //network session instance

    QSystemNetworkInfo* m_pNetInfo; //system network info instance

   QSystemNetworkInfo::NetworkStatus m_currNetworkStatus; //current network status


private slots:

    void OnOnlineStateChanged(bool isOnline); //notification when the current configuration online state changes (offline -> online and vice versa)
    void OnSessionStateChanged(QNetworkSession::State newState); //notification about session state change
    void OnNewConfigActivated(); //new network config activated for session
    void OnNetworkStatusChanged(QSystemNetworkInfo::NetworkMode mode, QSystemNetworkInfo::NetworkStatus newStatus);

signals:

    void onlineStateChanged(bool); //notification when online state has changed (boolean specified new state, i.e., online = true).
    void reconnectRequired(); //notification about changed connection state; reconnection is required (to re-init socket etc.).


};

#endif // CONNECTIONMANAGER_H
