#ifndef ARTIST_H
#define ARTIST_H
#include <libspotify/api.h>
#include <QObject>
#include <QString>

namespace Spotify
{
    class Link;
    class Artist: public QObject
    {
        Q_OBJECT

        public:
            explicit Artist( sp_artist* m_artist, bool ref = false, QObject *parent = 0);
            Artist( Spotify::Artist& artist, bool ref = false );
            QString getName() const { return m_name; }
            sp_artist* getArtist() const { return m_artist; }
            bool isLoaded() const { return m_isLoaded; }
            bool load();
            ~Artist();

            static Spotify::Artist* fromLink( Spotify::Link& link, QObject* parent = 0 );
        signals:
            void loaded();
            void updated();

        private:
            QString m_name;
            bool m_isLoaded;
            sp_artist* m_artist;
            bool m_hasRef;
    };
} // namespace Spotify

#endif // ARTIST_H
