//AboutDialog.cpp: Implementation of the custom AboutDialog class.

#include "AboutDialog.h"

AboutDialog::AboutDialog(QWidget *pParent)
    : QDialog(pParent)
{
    //Default constructor

    m_TextContent.setWordWrap(true);

    m_DoneBtn.setText(tr("Done"));

    //setup signal / slot connections
    connect(&m_DoneBtn,SIGNAL(clicked()),SLOT(OnDoneBtn()));

    m_MainLayout.addWidget(&m_Icon,0,0,1,1,Qt::AlignTop);
    m_MainLayout.addWidget(&m_TextContent,0,1,1,-1);
    m_MainLayout.addWidget(&m_DoneBtn,2,2);
    m_MainLayout.setRowStretch(2,50);

    setLayout(&m_MainLayout);
}

AboutDialog::~AboutDialog()
{
}

void AboutDialog::setText(const QString& text)
{
    //Set dialog text content
    m_TextContent.setText(text);
}

void AboutDialog::setIcon(const QString& iconPath)
{
    //set about dialog icon
    QPixmap appIconMap;
    appIconMap.load(iconPath); //load application icon from file
    m_Icon.setPixmap(appIconMap); //assign the icon pixmap
}

void AboutDialog::OnDoneBtn()
{
    //done button clicked handler (close dialog)
     accept();
}
