//ArtistView.h: Header file for the ArtistView class (displays albums, biography etc. associated with particular artist)

#ifndef ARTISTVIEW_H
#define ARTISTVIEW_H

#include <QMainWindow>
#include <QGridLayout>
#include <QListView>
#include <QModelIndex>
#include <QStandardItemModel>
#include <QStandardItem>
#include <QLabel>
#include <QPushButton>
#include <QMaemo5InformationBox>
#include <qspotify_src/spotifysession.h>
#include <qspotify_src/artistcatalogue.h>
#include <qspotify_src/artist.h>
#include <qspotify_src/imagecontainer.h>
#include "ListViewDelegate.h"
#include "CustomTextDialog.h"
#include "global_defs.h"

#define ARTIST_PORTRAIT_WIDTH   300
#define ARTIST_PORTRAIT_HEIGHT  300

class ArtistView : public QDialog
{
    Q_OBJECT

public:

    ArtistView(Spotify::Session* pSession, QWidget* pParent = 0); //constructor

    ~ArtistView(); //destructor

    void setArtist(Spotify::Artist* pArtist); //set current artist

    void setBiographyDlgOrientation(Qt::WidgetAttribute orientation); //set display orientation for the biography dialog instance

private:

    QGridLayout *m_pGridLayout; //main view gridlayout

    QLabel m_ArtistPortrait; //artist portrait

    QLabel m_ArtistCaption; //caption containing artist name

    QPushButton m_BiographyBtn; //button for accessing the artist biography

    QListView* m_pAlbumListView; //listview containing artist albums

    ListViewDelegate* m_pAlbumListViewDelegate; //delegate responsible for drawing the indivdual album items

    QStandardItemModel* m_pAlbumListModel; //model associated with listview

    Spotify::Session* m_pSession; //Spotify session instance

    Spotify::ImageContainer* m_pPortraitContainer; //album coverart container instance

    Spotify::ArtistCatalogue* m_pArtistCatalogue; //artist catalogue instance pointer

    QList<Spotify::Album*> m_ArtistAlbums; //list of artist albums sorted for display in listview

    CCustomTextDialog m_BiographyDlg; //Artist biography dialog instance

    void addAlbums(); //add artist albums to the listview

    QList<Spotify::Album*> sortArtistAlbums(); //arranges to albums returned by the artist browse request in desired order for listview

private slots:

    void OnArtistCatalogueReady(Spotify::ArtistCatalogue* pArtistCatalogue);
    void OnAlbumActivated(QModelIndex albumIndex);
    void OnArtistBiographyBtn();
    void OnArtistPortraitLoaded();
    void OnOrientationChanged(); //device orientation changed (e.g, screen rotate)

signals:

    void showAlbumView(Spotify::Album*); //request to display the album view dialog
};

#endif // ARTISTVIEW_H
