#ifndef USER_H
#define USER_H
#include <spotify/api.h>
#include <QObject>

namespace Spotify
{
    class User : public QObject
    {
        Q_OBJECT
        public:
            explicit User( sp_user* user, QObject *parent = 0);
            sp_user* getUser() const { return m_user; }
            bool isLoaded() const { return m_loaded; }
            QString getCanonicalName() const { return m_canonicalName; }
            QString getDisplayName() const { return m_displayName; }
            bool load();
            ~User();

        signals:
            void loaded();

        public slots:

        private:
            sp_user* m_user;
            bool m_loaded;
            QString m_canonicalName;
            QString m_displayName;

};

} // namespace Spotify

#endif // USER_H
