//MainWindow.h: Header file for main application window class.

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QWidget>
#include <QtGui/QMainWindow>
#include <QtGui/QMenuBar>
#include <QtGui/QAction>
#include <QtGui/QGridLayout>
#include <QtGui/QListView>
#include <QStandardItemModel>
#include <QModelIndex>
#include <QStandardItem>
#include <QtGui/QListWidget>
#include <QtGui/QListWidgetItem>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QPushButton>
#include <QtGui/QKeyEvent>
#include <QtGui/QCloseEvent>
#include <QSettings>
#include <QMessageBox>
#include <QFont>
#include <QTimer>
#include <QtMaemo5/QMaemo5InformationBox>
#include <qspotify_src/spotifysession.h>
#include "logindialog.h"
#include "SettingsDialog.h"
#include "TrackView.h"
#include "AlbumView.h"
#include "QueueView.h"
#include "SpectrumAnalyzer.h"
#include "customlabel.h"
#include "OssoWrapper.h"


//defines

#define APP_VERSION "0.1.0-3" //application version string

#define PLAYLIST_LOADING_TIMEOUT  30 //timeout before giving up on waiting for playlists to load (in seconds)

class MainWindow : public QMainWindow
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.maemo.qspot")

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:

    void keyPressEvent(QKeyEvent *evt);

private:

    QSettings* m_pAppSettings; //application settings instance

    QWidget m_MainLayout;

    QGridLayout m_GridLayout;

    LoginDialog* m_pLoginDlg;

    SettingsDialog* m_pSettingsDlg;

    TrackView* m_pTrackView;

    AlbumView* m_pAlbumView;

    QueueView* m_pQueueView; //playqueue (Now Playing) view instance

    Spotify::Session* m_pSession; //main Spotify session instance (handles communication with Spotify backend)

    OssoWrapper* m_pOssoWrapper; //wrapper instance for libosso

    QPushButton m_SearchBtn;

    QLineEdit m_SearchInput;

    QStandardItemModel *m_pPlaylistModel;

    ListViewDelegate *m_pPlaylistDelegate;

    QListView* m_pPlaylistView;

    QListWidget m_PlaylistInfo;

    CustomLabel m_NowPlayingIcon;

    QFont m_NowPlayingFont;

    CustomLabel m_NowPlayingInfo;

    CustomLabel m_NowPlayingPositionInfo;

    QString m_strNowPlayingInfo;

    SpectrumAnalyzer* m_pSpectrum; //spectrum analyzer widget

    QList<Spotify::Playlist*> m_Playlists; //list holding pointers to playlist instances

    QList<Spotify::Track*> m_PlayQueue; //current playqueue

    qint32 m_currQueuePos; //current position in the play queue (position of track being played)

    bool m_playing; //TRUE if in playing mode

    qint64 m_currPlaybackPos; //playback position for currently playing track

    QMessageBox m_AboutDlg; //App About dialog instance

    QTimer *m_pTimeoutTimer; //timer used for detecting timeouts (i.e., during playlist loading)

    bool m_AudioInit; //TRUE in case audio playback thread initialised

    void logout(); //logout current user and display the login dialog

    void initAboutDialog(); //setup the application about dialog



private slots:

     void OnShowLogin();
     void OnLoggedIn(Spotify::Error error);
     void OnPlaylistContainersReady(QList<Spotify::Playlist*> playlists);
     void OnPlaylistActivated(QModelIndex index);
     void OnLoginDialogRejected();
     void OnMainMenuAction(QAction* action);
     void OnPlayingState(bool state);
     void OnSetPlayQueue(const QList<Spotify::Track*>& queue);
     void OnPlayQueuePosUpdated(qint32 pos);
     void OnNowPlaying();
     void OnSearch();
     void OnSearchComplete(Spotify::Search* search);
     void OnPlaybackPositionUpdated(qint64 pos);
     void OnPlaybackTokenLost();
     void OnSettingsSaved();
     void OnPlaylistLoadingTimeout();
     void OnDisplayFMTransmitterDialog();
     void OnShowAlbumView(Spotify::Album* album);

signals:

     void showLogin();

};

#endif // MAINWINDOW_H
