//QueueView.h: Header file for the QueueView class (implements the queue  / Now Playing view)
#ifndef QUEUEVIEW_H
#define QUEUEVIEW_H

#include <QtGui/QWidget>
#include <QtGui/QLabel>
#include <QtGui/QPushButton>
#include <QtGui/QImage>
#include <QtGui/QBitmap>
#include <QtGui/QMainWindow>
#include <QtGui/QGridLayout>
#include <QtGui/QVBoxLayout>
#include <QtGui/QListView>
#include <QStandardItemModel>
#include <QItemSelectionModel>
#include <QMenuBar>
#include <QModelIndex>
#include <QStandardItem>
#include <QDebug>
#include <QScrollBar>
#include <QTextStream>
#include <QKeyEvent>
#include <QtGui/QPixmap>
#include <QMaemo5InformationBox>
#include <QAction>
#include <qspotify_src/spotifysession.h>
#include "CustomSlider.h"
#include "SpectrumAnalyzer.h"
#include "ListViewDelegate.h"
#include "OssoWrapper.h"

//defines

#define SLIDER_WIDTH 355 //width of the custom progress slider widget
#define SLIDER_HEIGHT 40 //height of the custom progress slider widget

#define QUEUEVIEW_ID 1

class QueueView : public QMainWindow
{
    Q_OBJECT

public:

    QueueView(Spotify::Session* pSession, OssoWrapper* pOsso, QWidget* parent = 0); //constructor
    ~QueueView();

    void setQueueInitialState(QList<Spotify::Track*> queue); //public method for setting the initial playqueue view state

    virtual void show(); //overriden show method


protected:

    void keyPressEvent(QKeyEvent *evt);

private:

    QWidget m_MainLayout;

    QGridLayout m_GridLayout;

    QGridLayout m_PlayControls;

    QLabel m_AlbumCoverContainer;

    QLabel m_ArtistName;

    QImage m_AlbumCoverPic; //current album cover (for selected track)

    QPushButton m_PauseResumeBtn; //pause / resume

    QPushButton m_PrevBtn; //prev track

    QPushButton m_NextBtn; //next track

    QPushButton m_ShuffleBtn; //shuffle tracks

    CustomSlider* m_pProgressSlider; //track progress indicator / slider

    SpectrumAnalyzer* m_pSpectrum; //spectrum (active during audio playback)

    QListView* m_pTrackInfoView; //track info listview

    QStandardItemModel *m_pTrackInfoModel;

    ListViewDelegate *m_pTrackInfoDelegate;

    Spotify::Session* m_pSession; //Spotify session instance

    OssoWrapper* m_pOssoWrapper; //OssoWrapper instance pointer

    Spotify::Track* m_pCurrTrack; //currently playing track in queue

    bool m_shuffle; //TRUE in case shuffle function enabled

    bool m_shuffleStateChanged; //TRUE in case shuffle state has been changed

    qint32 m_currShufflePos; //current position in the shuffle queue (playing)

    qint32 m_currShuffleBuffPos; //current position in shuffle queue being buffered (used in track pre-buffering mode)

    qint32 m_currQueuePos; //current position in play queue (track currently being played)

    qint32 m_currQueueBuffPos; //current position in playqueue being buffered (used in track pre-buffering mode)

    qint32 m_currTrackDuration; //current track duration (in secs)

    bool m_playing; //TRUE in case currently in playing state

    qint32 m_CallerID; //used as identifier to Spotify session calls that require caller ID

    QList<Spotify::Track*> m_PlayQueue; //current play queue

    QList<qint32> m_ShuffleQueue; //list holds random track positions (used by shuffle function)

    bool m_playbackStateChangeReq; //TRUE when i.e., the playback state needs to be chantged (to playing)

    void addTracks(QList<Spotify::Track*> trackList); //add tracks from specified tracklist to main listview

    void loadTrackData(Spotify::Track* track); //load data for specified track, e.g., album cover art

    void clearViewSelection(); //clear the current view selection (i.e., set to state when no track is active)

    void shuffleQueue(); //shuffle the current playqueue (the m_ShuffleQueue contains the shuffled queue positions)

    void playTrack(Spotify::Track* track); //request to play (stream) specified track

    void pausePlayback(); //request to pause music playback (and set the UI to corresponding state)

    void setupContextMenu(); //set up the listview context menu
    void setupMenubar(); //set up the view menubar



private slots:

    void OnTrackActivated(QModelIndex index);
    void OnPauseResumeToggle();
    void OnShuffleToggle();
    void OnTrackBufferedAmountUpdated(qint32 bufferedAmount);
    void OnPlaybackPositionUpdated(qint64 playbackPos);
    void OnAlbumCoverReady(QImage image, qint32 callerID);
    void OnTrackPlaybackFinished();
    void OnPlayingState(bool state);
    void OnNextTrackBtn();
    void OnPrevTrackBtn();
    void OnBufferNextTrack();
    void OnMenubarAction(QAction* action);
    void OnPlaybackStateChangeRequest(enum pb_state_e requestedState);
    void OnViewAlbumAction();
    void OnPlayAlbumAction();
    void OnAlbumBrowseReady(Spotify::AlbumBrowser* browser, qint32 callerID);

signals:

    void playQueuePosUpdated(qint32); //signal emitted when position in playqueue has been updated
    void showFMTransmitterDialog(); //signal emitted upon request to show the FM Transmitter control panel plugin
    void showAlbumView(Spotify::Album*); //request to show the album view for the specified album
};

#endif // QUEUEVIEW_H
