#ifndef ALBUM_H
#define ALBUM_H
#include <spotify/api.h>
#include "artist.h"
#include "imagecontainer.h"

namespace Spotify
{
    class Session;
    class Artist;
    class Link;
    class Album: public QObject, public Spotify::ImageContainer
    {
        Q_OBJECT
        public:
            enum Type { ALBUM, SINGLE, COMPILATION, UNKNOWN };
            explicit Album( sp_album* album, bool ref = false, QObject *parent = 0);
            Album( Spotify::Album& album, bool ref = false );
            bool load();

            sp_album* getAlbum() const { return m_album; }
            bool isLoaded() const { return m_isLoaded; }
            bool isAvailable() const { return m_isAvailable; }
            Spotify::Artist* getArtist() { return m_artist; }
            const byte* getCover() { return m_cover; }
            QString getName() const { return m_name; }
            int getYear() const { return m_year; }
            Spotify::Album::Type type() const { return m_type; }
            virtual QString getTypeName() { return "Album Cover Container"; }
            void loadCoverArt();
            ~Album();

            // From ImageContainer:
            virtual void setImage( QImage image );

            static Spotify::Album* fromLink( Spotify::Link& link, QObject* parent = 0 );

        signals:
            void loaded();
            void coverArtLoaded();

        public slots:

        private:
            sp_album* m_album;
            bool m_isLoaded;
            bool m_isAvailable;
            Spotify::Artist* m_artist;
            const byte* m_cover;
            QString m_name;
            int m_year;
            Spotify::Album::Type m_type;
            bool m_hasRef;
    };

} // namespace Spotify

#endif // ALBUM_H
