#include "logindialog.h"

LoginDialog::LoginDialog(Spotify::Session* pSession, QSettings* pSettings, QWidget *parent)
    : QDialog(parent)
{

 //construct main UI dialog

    //connect signals etc.

    m_pSession = pSession;

    m_pAppSettings = pSettings;

    m_bSessionInit = false;

    connect(&m_LoginBtn,SIGNAL(clicked()),SLOT(OnLogin()));
    connect(m_pSession,SIGNAL(loggedIn(Spotify::Error)),SLOT(OnLoggedIn(Spotify::Error)));

    setWindowTitle(tr("QSpot - Login"));

    //set up UI elements
    m_UserIDText.setText(tr("UserID:"));
    m_PasswordText.setText(tr("Password:"));
    m_PasswordInput.setEchoMode(QLineEdit::Password);

    m_SaveCredentials.setText(tr("Remember UserID and password"));
    m_LoginBtn.setText(tr("Login"));

    if(m_pAppSettings)
    {
        //read save credentials state from the app settings file
        int saveCredentials = m_pAppSettings->value("QSpot/SaveCredentials",0).toInt();
        if(saveCredentials)
        { //restore saved credentials (UserID and password) from settings file
            m_SaveCredentials.setChecked(true);
            m_UserIDInput.setText(m_pAppSettings->value("QSpot/UserID","").toString());
            m_PasswordInput.setText(m_pAppSettings->value("QSpot/Password","").toString());
        }
    }

    m_Layout.addWidget(&m_UserIDText,0,0);
    m_Layout.addWidget(&m_UserIDInput,0,1);
    m_Layout.addWidget(&m_PasswordText,1,0);
    m_Layout.addWidget(&m_PasswordInput,1,1);
    m_Layout.addWidget(&m_SaveCredentials,2,0,1,-1);
    m_Layout.addWidget(&m_LoginBtn,3,1);

    setLayout(&m_Layout);
}

LoginDialog::~LoginDialog()
{

}

void LoginDialog::OnLogin()
{
    QMessageBox msgBox;

    //request to login to Spotify
    if(!m_bSessionInit)
    {
        m_pSession->init(); //init the spotify session (if not already done)
        m_bSessionInit = true;
    }
    Spotify::Error err = m_pSession->login(m_UserIDInput.text(),m_PasswordInput.text());
    if(err.isError())
    {
        msgBox.setText("Error:" + err.toString());
        msgBox.exec();
    }
    else
    {
        m_LoginBtn.setDisabled(true);
        setAttribute(Qt::WA_Maemo5ShowProgressIndicator,true); //display progress indicator
    }
}

void LoginDialog::OnLoggedIn(Spotify::Error error)
{
    if(!error.isError())
    {
        //succesfully logged in
        if(m_SaveCredentials.checkState()==Qt::Checked)
        {
            m_pAppSettings->setValue("QSpot/SaveCredentials",1);
            
m_pAppSettings->setValue("QSpot/UserID",m_UserIDInput.text());
            
m_pAppSettings->setValue("QSpot/Password",m_PasswordInput.text());
        }
        else
        { //credentials should not be saved, remove any existing values
            m_pAppSettings->setValue("QSpot/SaveCredentials",0);
            m_pAppSettings->setValue("QSpot/UserID","");
            m_pAppSettings->setValue("QSpot/Password","");
        }
    }
}

void LoginDialog::resetState()
{
	//reset state after e.g., unsuccessful login
	setAttribute(Qt::WA_Maemo5ShowProgressIndicator,false); //hide progress indicator
	m_LoginBtn.setDisabled(false);
	m_UserIDInput.setText("");
	m_UserIDInput.setCursorPosition(0);
	m_PasswordInput.setText("");
	m_PasswordInput.setCursorPosition(0);
	m_UserIDInput.setFocus();
}

