#ifndef CUSTOMSLIDER_H
#define CUSTOMSLIDER_H

#include <QWidget>
#include <QMouseEvent>

class CustomSlider : public QWidget
{
	Q_OBJECT

public:
	CustomSlider(QWidget *parent, int width, int height);
	~CustomSlider();

	void setPos1(int pos);
	void setPos2(int pos);
	void setBgColor(QColor color);
	void setP1Color(QColor color);
	void setP2Color(QColor color);

protected:
	void paintEvent(QPaintEvent *event);
	void mousePressEvent(QMouseEvent *event);

private:
	QColor m_bgcolor;
	QColor m_p1color;
	QColor m_p2color;
	int m_width;
	int m_height;
	int m_pos1;
	int m_pos2;

signals:
    void positionChanged(int);
};

#endif // CUSTOMSLIDER_H
