﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

import time, re
from QonsoExtractor import QonsoExtractor
from PyQt4 import QtWebKit, QtCore, QtGui
from PyQt4.QtNetwork import QNetworkAccessManager, QNetworkRequest, QNetworkReply, QNetworkProxy, QNetworkCookieJar

class QonsoExtractorSFR(QonsoExtractor):
   def __init__(self, view):
      self.view = view
      QonsoExtractor.__init__(self, view)
      self.SetStatus('INFO', "Initialisation...")
      self.urlconso = "https://monprofil.sfr.fr/monprofilWEBV5/Accueil?acces=enc"
      self.urlbeforeAuth = "https://www.sfr.fr/cas/login?domain=mon-compte"
      self.urlAuth = "https://www.sfr.fr/cas/login?domain=mon-compte&service=https%3A%2F%2Fwww.sfr.fr%2Fj_spring_cas_security_check"
      self.hostname = "www.sfr.fr"
      
   def Authenticate(self):
      self.SetStatus('INFO', 'Authentification...')

      request = QNetworkRequest()
      request.setUrl( QtCore.QUrl(self.urlAuth) ) 
      request.setHeader(QNetworkRequest.ContentTypeHeader, "application/x-www-form-urlencoded")
      request.setRawHeader("Connection", "keep-alive")
      request.setRawHeader("Keep-Alive", "115");
      request.setRawHeader("Referer", self.urlbeforeAuth)
      request.setRawHeader("Host", self.hostname)
      
      cookies = self.manager.cookieJar().cookiesForUrl(QtCore.QUrl("http://"+self.hostname))

      params = QtCore.QUrl()
      params.addQueryItem("username", self.login)
      params.addQueryItem("password", self.password)
      params.addQueryItem("internal", "W")

      postData = QtCore.QByteArray()
      postData.append(params.toString()[1:])

      request.setRawHeader("Content-Length", "%s" % postData.length() )
   
      self.manager.post(request, postData)
      
   def DoReadResponse(self, reply):
      request = QNetworkRequest()
      
      # Phase d'initialisation, on va extraire 'idCorrelation', et on lance l'authentification avec
      if self.authentication=='Init':
         self.authentication = 'InProgress'
         self.Authenticate()
      
      # Authentification en cours, on récupère la page de redirection, et on fait une redirection
      elif self.authentication == 'InProgress':
         html = reply.readAll()
         self.frame.setHtml(str(html))
         errors = self.frame.findAllElements('p[class="error"]')

         if errors:
            self.Debug("erreur")
            for error in errors:
               self.SetStatus('ERROR', error.toPlainText())
               return
         else:
            # pas d'erreur, c'est Lesieur, on peut charger la page des consommations
            request.setUrl( QtCore.QUrl(self.urlconso) ) 
            self.authentication = 'Done'
            self.manager.get(request)

   def ExtractDatas(self, datas):
      self.SetStatus('INFO', 'R&eacute;cup&eacute;ration des donn&eacute;es...')
      self.frame.setHtml( str(datas) )
      
      elem = self.frame.findAllElements('div[class="mea_ctt"]')
      self.Debug("\n\n\n")
      
      for i in range (elem.count()):
         strElem = str(elem.at(i).toPlainText().toAscii())
         
         self.Debug("____________________________________________\n"+str(i)+" : "+strElem)
         self.Debug("-----------------------------------------------\n")
         res = re.search(u"SFR Entreprises (\d*\s*[Hh]*\s*\d+)\s*mn et vous avez consommé\s(\d*\s*[Hh]*\s*\d+)\s*mn de communication", strElem)
         if res:
            self.model.SetConsoVoixMax( res.group(1) )
            self.model.SetConsoVoix( res.group(2) )
            self.Debug("voix1 = "+res.group(1))
            self.Debug("voixMax1 = "+res.group(2))
            
         res = re.search("Il vous reste (\d*\s*[Hh]*\s*\d+)\s*mn de communication .* (\d* [Hh]* \d+ mn)", strElem)
         if res:
            self.model.SetConsoVoix( res.group(1) )
            self.model.SetConsoVoixMax( res.group(2) )
            self.Debug("voix2 = "+res.group(1))
            self.Debug("voixMax2 = "+res.group(2))

         res = re.search("Le (.+) (\d+) heures et (\d+) minutes", strElem)
         if res:
            date = res.group(1)
            time = "%sh%.2d" % ( res.group(2), int(res.group(3)) )
            self.model.lastTime = "Ma consommation au "+date + " "+ time
            self.Debug("last="+self.model.lastTime)
            
         res = re.search("avant le (.+)", strElem)
         if res:
            self.model.facture = "Date de la prochaine facture : "+res.group(1)
            self.Debug("facture="+self.model.facture)
            
         res = re.search("Report Forfait.* (\d*\s*[Hh]*\s*\d+) mn de communication", strElem)
         if res:
            self.Debug("report = "+res.group(1))
            self.model.SetReport( res.group(1) )

         res = re.search("hors forfait.*(\d+\.\d+).+TTC", strElem)
         if res:
            self.model.hforfait = "Hors forfait : "+res.group(1)+u"€"
            self.Debug("hforfait = "+res.group(1))

      #self.model.data = elem.at(1).toPlainText()
      self.model.sms = "0"
      self.SetStatus('INFO', u'Données récupérées...')

      self.view.update()
