﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

import time, re, os
from QonsoExtractor import QonsoExtractor
from PyQt4 import QtWebKit, QtCore, QtGui
from PyQt4.QtNetwork import QNetworkAccessManager, QNetworkRequest, QNetworkReply, QNetworkProxy, QNetworkCookieJar

class QonsoExtractorBouygues(QonsoExtractor):
   def __init__(self, view):
      self.debug = os.environ.has_key('DEBUG')
      QonsoExtractor.__init__(self, view)
      self.urlconso = "http://www.espaceclient.bouyguestelecom.fr/ECF/jsf/client/conso-factures/details-conso/viewDetailsConso.jsf"
      self.urlbeforeAuth = "https://www.espaceclient.bouyguestelecom.fr/ECF/jsf/submitLogin.jsf"
      self.urlAuth = "https://www.espaceclient.bouyguestelecom.fr/ECF/jsf/j_security_check;jsessionId="
      self.hostname = "www.espaceclient.bouyguestelecom.fr"
      self.i = 1

   def Authenticate(self, idCorrelation):
      self.SetStatus('INFO', 'Authentification...')

      request = QNetworkRequest()
      request.setUrl( QtCore.QUrl(self.urlAuth+idCorrelation) ) 
      request.setHeader(QNetworkRequest.ContentTypeHeader, "application/x-www-form-urlencoded")
      request.setRawHeader("Connection", "keep-alive")
      request.setRawHeader("Keep-Alive", "115");
      request.setRawHeader("Referer", self.urlbeforeAuth)
      request.setRawHeader("Host", self.hostname)
      
      cookies = self.manager.cookieJar().cookiesForUrl(QtCore.QUrl("http://"+self.hostname))

      for cookie in cookies:
         if cookie.name()=="JSESSIONID":
            request.setRawHeader("Cookie", "testcookie; "+cookie.name()+"="+cookie.value())

      params = QtCore.QUrl()
      params.addQueryItem("j_username", self.login)
      params.addQueryItem("j_password", self.password)
      params.addQueryItem("application_name", "ESPACE_CLIENT_WEB_FORFAIT")
      params.addQueryItem("idCorrelation", idCorrelation)

      postData = QtCore.QByteArray()
      postData.append(params.toString()[1:])

      request.setRawHeader("Content-Length", "%s" % postData.length() )
   
      self.manager.post(request, postData)
      
   def DoReadResponse(self, reply):
      request = QNetworkRequest()

      # Phase d'initialisation, on va extraire 'idCorrelation', et on lance l'authentification avec
      if self.authentication=='Init':
         html = reply.readAll()
         self.frame.setHtml(str(html))
         idCorrelation = self.frame.findFirstElement('input[name=idCorrelation]').attribute('value')
         self.authentication = 'InProgress'
         self.Authenticate(idCorrelation)
      
      # Authentification en cours, on récupère la page de redirection, et on fait une redirection
      elif self.authentication == 'InProgress':
         possibleRedirectUrl = reply.attribute(QNetworkRequest.RedirectionTargetAttribute)
         redirectUrl = possibleRedirectUrl.toUrl()
         request.setUrl( redirectUrl ) 
         self.manager.get(request)
         self.authentication = 'Redirecting'

      # Gestion des redirections, il peut y en avoir plusieurs à la suite
      elif self.authentication == 'Redirecting':
         possibleRedirectUrl = reply.attribute(QNetworkRequest.RedirectionTargetAttribute)
         redirectUrl = str(possibleRedirectUrl.toUrl().toString())
         self.Debug(redirectUrl+str(redirectUrl.find("submitLoginError")))
         
         if redirectUrl and redirectUrl.find("submitLoginError")>0:
            self.SetStatus('ERROR', "Erreur avec vos identifiants")
            redirectUrl = redirectUrl[ redirectUrl.rfind("http"): ]
            request.setUrl( QtCore.QUrl(redirectUrl) ) 
            
         else:
            self.Debug("No more redirection")
            # pas de redirection, on vérifie s'il n'y a pas d'erreur dans la page
            html = reply.readAll()
            self.frame.setHtml(str(html))
            errors = self.frame.findAllElements('div[class=erreur]')
            if errors:
               self.Debug("found erreur")
               for error in errors:
                  if error.attribute('id'):  # pas cette erreur (div avec id=errorCookie)
                     continue
                  self.SetStatus('ERROR', error.toInnerXml())
                  return
            else:
               self.Debug( "Pas d'erreur : "+self.status)
               # pas d'erreur, c'est Lesieur, on peut charger la page des consommations
               if self.status == 'ERROR':
                  return
               self.authentication = 'Done'
               self.Debug( "set request="+self.urlconso)
               request.setUrl( QtCore.QUrl(self.urlconso) ) 
               self.SetStatus('INFO', 'R&eacute;cup&eacute;ration des donn&eacute;es...')
            
         self.manager.get(request)


   def ExtractDatas(self, datas):
      self.Debug("ExtractDatas")
      self.SetStatus('INFO', 'R&eacute;cup&eacute;ration des donn&eacute;es...')

      self.frame.setHtml( str(datas) )
      
      date = self.frame.findFirstElement('span[id="viewConsoFacture:okMetier:encartVoix:DetailConsoDateConso"]').toPlainText()
      time = self.frame.findFirstElement('span[id="viewConsoFacture:okMetier:encartVoix:DetailConsoHeureConso"]').toPlainText()
      self.model.lastTime = "Ma consommation au "+date + " &agrave; " + time

      elem = self.frame.findAllElements('div td strong span')
      
      self.model.SetConsoVoix( str(elem.at(0).toPlainText().toAscii()) )
#      self.model.data = elem.at(1).toPlainText()
      self.model.hforfait = elem.at(1).toPlainText()

      date = self.frame.findFirstElement('span[id="viewConsoFacture:okMetier:encartDateFacture:dateEmissionFacture"]').toPlainText()
      self.model.facture = "Prochaine facture : "+date+" au soir"
      self.model.sms = "0"

      elem = self.frame.findAllElements('div[class="intitule"]')
      for i in range (elem.count()):
         strElem = str( elem.at(i).toPlainText().toUtf8() )
         self.Debug("____________________________________________\n"+str(i)+" : "+strElem)
         self.Debug("-----------------------------------------------\n")

         res = re.search("report de minutes de (\d*\s*[Hh]*\s*\d\d)", strElem)
         if res:
            self.model.SetReport( res.group(1) )
            self.Debug("report = "+res.group(1))
         
         res = re.search("Sur votre forfait (.+).* de (\d*\s*[Hh]*\s*\d\d)", strElem )
         if res:
            if res.group(1).find("Neo")>0:
               self.model.dataMax = 500
            self.model.SetConsoVoixMax( res.group(2) )

      self.view.update()
