#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PySide import QtCore, QtGui

#Вычисляе разницу во времени между двумя датами заданными в стандарте ISO
#Возвращает время в секундах
def diffStrTime(strStartTime, strEndTime):
	qdt1 = QtCore.QDateTime.fromString( strEndTime, 'yyyy-MM-dd HH:mm:ss' )
	qdt0 = QtCore.QDateTime.fromString( strStartTime, 'yyyy-MM-dd HH:mm:ss' )
	qdt_delta = qdt0.secsTo( qdt1 )
	return qdt_delta


#вычисляет время сессии, разделенное на компоненты времени
def sessionTime( strStartTime, strEndTime ):
	delta_sec = diffStrTime( strStartTime, strEndTime )
	
	Hs,ok = divmod( delta_sec, 3600 )
	if Hs != 0:
		delta_sec = delta_sec - Hs*3600

	Ms,ok = divmod( delta_sec, 60 )
	if Ms != 0:
		delta_sec = delta_sec - Ms*60
	
	Ss = delta_sec
	return (Hs,Ms,Ss)

def strHumanBytes(bytes):
	bytes = int( bytes )
	strRet = ""
	if bytes > 1048576:
		strRet = "%.2f MB"%( bytes/1048576.0 )
	elif bytes > 1024:
		strRet = "%.2f kB"%( bytes/1024.0 )
	else:
		strRet = "%s B"%( bytes )
	
	return strRet

def traffSession( bufTraff ):
	siz_bufTraff = len( bufTraff )
	rx0 = (int)(bufTraff[0]['rx'])
	tx0 = (int)(bufTraff[0]['tx'])
	rx1 = (int)(bufTraff[siz_bufTraff-1]['rx'])
	tx1 = (int)(bufTraff[siz_bufTraff-1]['tx'])
	rx = rx1 - rx0
	tx = tx1 - tx0
	return ( rx, tx )

def pixmapIface( name_iface ):
	if name_iface == "gprs0":
		item_pic = QtGui.QPixmap(":/pic48/pictures/gprs.png" )
	elif name_iface == "wlan0":
		item_pic = QtGui.QPixmap(":/pic48/pictures/wifi.png" )
	elif name_iface == "pan0":
		item_pic = QtGui.QPixmap(":/pic48/pictures/pan.png" )
	elif name_iface == "eth0":
		item_pic = QtGui.QPixmap(":/pic48/pictures/eth.png" )
	elif name_iface == "usb0":
		item_pic = QtGui.QPixmap(":/pic48/pictures/usb.png" )
	else:
		item_pic = QtGui.QPixmap(":/pic48/pictures/unknown.png" )
	
	return item_pic
