#ifndef SETTINGS_H
#define SETTINGS_H

#include "qmlapplicationviewer.h"
#include <QSettings>
#include <QStringList>

class Settings : public QSettings
{
    Q_OBJECT
    Q_PROPERTY(QString youtubeDownloadQuality
               READ getYouTubeDownloadQuality
               WRITE setYouTubeDownloadQuality
               NOTIFY youtubeDownloadQualityChanged)
    Q_PROPERTY(QString homescreen
               READ getHomescreen
               WRITE setHomescreen
               NOTIFY homescreenChanged)
    Q_PROPERTY(QString downloadPath
               READ getDownloadPath
               WRITE setDownloadPath
               NOTIFY downloadPathChanged)
    Q_PROPERTY(QString defaultTransferStatus
               READ getDefaultTransferStatus
               WRITE setDefaultTransferStatus
               NOTIFY defaultTransferStatusChanged)
    Q_PROPERTY(QString transferPriority
               READ getTransferPriority
               WRITE setTransferPriority
               NOTIFY transferPriorityChanged)
    Q_PROPERTY(bool pauseWhenMinimized
               READ getPauseWhenMinimized
               WRITE setPauseWhenMinimized
               NOTIFY pauseWhenMinimizedChanged)
    Q_PROPERTY(bool safeSearch
               READ getSafeSearch
               WRITE setSafeSearch
               NOTIFY safeSearchChanged)
    Q_PROPERTY(QStringList recentSearches
               READ getRecentSearches
               WRITE setRecentSearches
               NOTIFY recentSearchesChanged)
    Q_PROPERTY(QString searchOrder
               READ getSearchOrder
               WRITE setSearchOrder
               NOTIFY searchOrderChanged)
    Q_PROPERTY(QString appTheme
               READ getTheme
               WRITE setTheme
               NOTIFY themeChanged)
    Q_PROPERTY(QString activeColor
               READ getActiveColor
               WRITE setActiveColor
               NOTIFY activeColorChanged)
    Q_PROPERTY(QString activeColorString
               READ getActiveColorString
               WRITE setActiveColorString
               NOTIFY activeColorStringChanged)
    Q_PROPERTY(QString gradientColor
               READ getGradientColor
               WRITE setGradientColor
               NOTIFY gradientColorChanged)
    Q_PROPERTY(QString gradientColorHigh
               READ getGradientColorHigh
               WRITE setGradientColorHigh
               NOTIFY gradientColorHighChanged)
    Q_PROPERTY(QString language
               READ getLanguage
               WRITE setLanguage
               NOTIFY languageChanged)
    Q_PROPERTY(QString screenOrientation
               READ getOrientation
               WRITE setOrientation
               NOTIFY orientationChanged)
    Q_PROPERTY(QString networkProxy
               READ getNetworkProxy
               WRITE setNetworkProxy
               NOTIFY networkProxyChanged)
    Q_PROPERTY(QString mediaPlayer
               READ getMediaPlayer
               WRITE setMediaPlayer
               NOTIFY mediaPlayerChanged)
    Q_PROPERTY(QString defaultSite
               READ getDefaultSite
               WRITE setDefaultSite
               NOTIFY defaultSiteChanged)
    Q_PROPERTY(bool xtubeEnabled
               READ getXTubeEnabled
               NOTIFY xtubeEnabledChanged)
    Q_PROPERTY(QString xtubeDownloadPath
               READ getXTubeDownloadPath
               NOTIFY xtubeDownloadPathChanged)
    Q_PROPERTY(QString uploadAttribute
               READ getUploadAttribute
               WRITE setUploadAttribute
               NOTIFY uploadAttributeChanged)
    Q_PROPERTY(bool signedInToAccounts
               READ getSignedInToAccounts
               NOTIFY signedInToAccountsChanged)
    Q_PROPERTY(bool showRelatedVideos
               READ getShowRelatedVideos
               WRITE setShowRelatedVideos
               NOTIFY showRelatedVideosChanged)
    Q_PROPERTY(int maximumFlickVelocity
               READ getMaximumFlickVelocity
               WRITE setMaximumFlickVelocity
               NOTIFY maximumFlickVelocityChanged)

public:
    explicit Settings(QSettings *parent = 0);
    virtual ~Settings();
    void restoreSettings();
    QString getYouTubeDownloadQuality() const { return youtubeDownloadQuality; }
    QString getHomescreen() const { return homescreen; }
    QString getDefaultTransferStatus() const { return defaultTransferStatus; }
    QString getTransferPriority() const { return transferPriority; }
    bool getPauseWhenMinimized() { return pauseWhenMinimized; }
    QString getDownloadPath() const { return downloadPath; }
    bool getSafeSearch() { return safeSearch; }
    QStringList getRecentSearches() const { return recentSearches; }
    QString getSearchOrder() const { return searchOrder; }
    QString getTheme() const { return theme; }
    QString getActiveColor() const { return activeColor; }
    QString getActiveColorString() const { return activeColorString; }
    QString getGradientColor() const { return gradientColor; }
    QString getGradientColorHigh() const { return gradientColorHigh; }
    QString getLanguage() const { return language; }
    QString getOrientation() const { return screenOrientation; }
    QString getNetworkProxy() const { return networkProxy; }
    QString getMediaPlayer() const { return mediaPlayer; }
    QString getDefaultSite() const { return defaultSite; }
    bool getXTubeEnabled() { return xtubeEnabled; }
    QString getXTubeDownloadPath() const { return xtubeDownloadPath; }
    QString getUploadAttribute() const { return uploadAttribute; }
    bool getSignedInToAccounts() { return signedInToAccounts; }
    bool getShowRelatedVideos() { return showRelatedVideos; }
    int getMaximumFlickVelocity() { return maximumFlickVelocity; }

signals:
    void youtubeDownloadQualityChanged(const QString &quality);
    void homescreenChanged();
    void defaultTransferStatusChanged();
    void transferPriorityChanged(const QString &priority);
    void pauseWhenMinimizedChanged();
    void downloadPathChanged(const QString &path);
    void updateWidgetDownloadPath(const QString &path);
    void safeSearchChanged();
    void recentSearchesChanged();
    void searchOrderChanged();
    void themeChanged();
    void activeColorChanged();
    void activeColorStringChanged();
    void gradientColorChanged();
    void gradientColorHighChanged();
    void languageChanged();
    void orientationChanged(const QString &orientation);
    void alert(const QString &message);
    void networkProxyChanged(const QString &proxy);
    void mediaPlayerChanged(const QString &player);
    void defaultSiteChanged();
    void youtubeUsernameChanged(const QString &user);
    void youtubeAccessTokenChanged(const QString &token);
    void dailymotionAccountChanged(const QString &user, const QString &aToken, const QString &rToken, int tokenExpiry);
    void xtubeEnabledChanged();
    void xtubeDownloadPathChanged(const QString &path);
    void facebookAccessTokenChanged(const QString &token);
    void twitterAccountChanged(const QString &token, const QString &secret);
    void uploadAttributeChanged();
    void xtubeQualityChanged(const QString &quality);
    void signedInToAccountsChanged();
    void showRelatedVideosChanged();
    void maximumFlickVelocityChanged();

public slots:
    void saveSettings();
    void setYouTubeDownloadQuality(const QString &quality);
    void setHomescreen(const QString &screen);
    void setDefaultTransferStatus(const QString &status);
    void setTransferPriority(const QString &priority);
    void setPauseWhenMinimized(bool pause);
    void setDownloadPath(const QString &path, bool updateWidget = true);
    void setSafeSearch(bool safe);
    void setRecentSearches(const QStringList &searches);
    void setSearchOrder(const QString &order);
    void setTheme(const QString &aTheme);
    void setActiveColor(const QString &color);
    void setActiveColorString(const QString &colorString);
    void setLanguage(const QString &lang);
    void setOrientation(const QString &orientation);
    void setNetworkProxy(const QString &proxy);
    void setMediaPlayer(const QString &player);
    void setDefaultSite(const QString &site);
    void setYouTubeUsername(const QString &user, bool signIn = true);
    void setYouTubeAccessToken(const QString &token, bool signIn = true);
    void setDailymotionAccount(const QString &user, const QString &aToken, const QString &rToken, int tokenExpiry, bool signIn = true);
    void clearYouTubeAccount();
    void clearDailymotionAccount();
    QVariantList getLanguages() const;
    void setFacebookAccessToken(const QString &token);
    void setTwitterAccount(const QString &token, const QString &secret);
    void clearFacebookAccount();
    void clearTwitterAccount();
    void setUploadAttribute(const QString &attribute);
    void signInToAccounts();
    void setShowRelatedVideos(bool show);
    void setMaximumFlickVelocity(int velocity);

private:
    void setXTubeEnabled(bool enabled);
    void setXTubeDownloadPath(const QString &path);
    void setXTubeQuality(const QString &quality);
    void setGradientColor(const QString &color);
    void setGradientColorHigh(const QString &color);
    void setSignedInToAccounts(bool signedIn);

private:
    QString youtubeDownloadQuality;
    QString homescreen;
    QString defaultTransferStatus;
    QString transferPriority;
    bool pauseWhenMinimized;
    QString downloadPath;
    bool safeSearch;
    QStringList recentSearches;
    QString searchOrder;
    QString theme;
    QString activeColor;
    QString activeColorString;
    QString gradientColor;
    QString gradientColorHigh;
    QString language;
    QString screenOrientation;
    QString networkProxy;
    QString mediaPlayer;
    QString defaultSite;
    QString youtubeUsername;
    QString youtubeAccessToken;
    QString dailymotionAccessToken;
    QString dailymotionRefreshToken;
    QString dailymotionUsername;
    bool xtubeEnabled;
    QString xtubeDownloadPath;
    QString facebookAccessToken;
    QString twitterAccessToken;
    QString twitterTokenSecret;
    QString uploadAttribute;
    QString xtubeQuality;
    bool signedInToAccounts;
    bool showRelatedVideos;
    int maximumFlickVelocity;
};

#endif // SETTINGS_H
