import QtQuick 1.0

Item {
    id: root

    property alias titleText: title.text
    property alias menuItems: buttonColumn.children
    property bool destroyOnClosing: false

    signal accepted
    signal rejected

    function accept() {
        root.accepted();
        root.close();
    }

    function reject() {
        root.rejected();
        root.close();
    }

    function open() {
        pageStack.dim();
        root.state = "open";
    }

    function close() {
        pageStack.undim();
        root.state = "";
        if (destroyOnClosing) {
            root.destroy(1000);
        }
    }

    parent: appWindow
    width: appWindow.inPortrait ? appWindow.width : 350
    height: appWindow.inPortrait ? buttonColumn.height + 70 : appWindow.height
    anchors { left: appWindow.inPortrait ? parent.left : parent.right; top: appWindow.inPortrait ? parent.bottom : parent.top }

    Rectangle {
        id: background

        anchors.fill: root
        color: _BACKGROUND_COLOR
        opacity: 0.8
    }

    Rectangle {
        height: 2
        anchors { left: root.left; right: root.right; top: root.top }
        color: Settings.activeColor
        opacity: 0.5
        visible: appWindow.inPortrait
    }

    Rectangle {
        width: 2
        anchors { left: root.left; top: root.top; bottom: root.bottom }
        color: Settings.activeColor
        opacity: 0.5
        visible: !appWindow.inPortrait
    }

    Label {
        id: title

        anchors { top: root.top; left: root.left; right: root.right; margins: 10 }
        
        
        font.bold: true
        horizontalAlignment: Text.AlignHCenter
        elide: Text.ElideRight
        visible: text != ""
    }

    Column {
        id: buttonColumn

        anchors { left: root.left; right: root.right; top: title.bottom; margins: 10 }
        spacing: 10
    }

    MouseArea {
        z: -1
        anchors.fill: root
    }

    MouseArea {
        z: 1000
        parent: pageStack
        anchors.fill: parent
        enabled: root.state == "open"
        onClicked: close()
    }

    states: State {
        name: "open"
        AnchorChanges { target: root; anchors { top: appWindow.inPortrait ? undefined: parent.top; bottom: appWindow.inPortrait ? parent.bottom : undefined; right: parent.right; left: appWindow.inPortrait ? parent.left : undefined } }
    }

    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 300 }
    }
}
