import QtQuick 1.0
import "components"

Page {
    id: root

    property Item xtubePage: null
    property Item archivePage: null

    function loadXTubeSearch() {
        xtubePage = tabGroup.addTab(Qt.resolvedUrl("XTubeListPage.qml"), 0);
    }

    function loadXTubeArchive() {
        archivePage = tabGroup.addTab(Qt.resolvedUrl("XTubeArchivePage.qml"), 1);
    }

    title: tabGroup.currentTab === null ? "XTube" : tabGroup.currentTab.title
    tools: tabGroup.currentTab === null ? null : tabGroup.currentTab.tools

    Component.onCompleted: loadXTubeSearch()

    TabGroup {
        id: tabGroup

        anchors { fill: parent; topMargin: titleArea.height + tabBar.height }
    }

    TabBar {
        id: tabBar

        anchors { left: parent.left; right: parent.right; top: parent.top; topMargin: titleArea.height }

        buttons: [
            TabButton {
                text: qsTr("Search")
                checked: tabGroup.index == 0
                onClicked: if (xtubePage === null) loadXTubeSearch(); else tabGroup.setTab(0);
            },

            TabButton {
                text: qsTr("Archive")
                checked: tabGroup.index == 1
                onClicked: if (archivePage === null) loadXTubeArchive(); else tabGroup.setTab(1);
            }
        ]
    }
}
