#ifndef DAILYMOTION_H
#define DAILYMOTION_H

#include <QObject>
#include <QUrl>
#include <QFile>
#include <QTime>
#include <QVariantMap>
#include <QTimer>

class QNetworkAccessManager;
class QNetworkReply;

class Dailymotion : public QObject {
    Q_OBJECT
    Q_PROPERTY(QString username
               READ getUsername
               NOTIFY usernameChanged)
    Q_PROPERTY(QString accessToken
               READ getAccessToken
               NOTIFY accessTokenChanged)
    Q_PROPERTY(QString refreshToken
               READ getRefreshToken
               NOTIFY refreshTokenChanged)
    Q_PROPERTY(QString tokenExpiry
               READ getTokenExpiry
               NOTIFY tokenExpiryChanged)
    Q_PROPERTY(QString clientId
               READ getClientId
               NOTIFY clientIdChanged)
    Q_PROPERTY(QString clientSecret
               READ getClientSecret
               NOTIFY clientSecretChanged)
    Q_PROPERTY(bool userSignedIn
               READ getUserSignedIn
               NOTIFY userSignedInChanged)
    Q_PROPERTY(QString busyMessage
               READ getBusyMessage
               NOTIFY busyMessageChanged)


public:
    explicit Dailymotion(QObject *parent = 0);

    void setNetworkAccessManager(QNetworkAccessManager *manager);
    QString getUsername() const { return username; }
    QString getAccessToken() const { return accessToken; }
    QString getRefreshToken() const { return refreshToken; }
    int getTokenExpiry() const { return tokenExpiry; }
    QString getClientId() const { return clientId; }
    QString getClientSecret() const { return clientSecret; }
    bool getUserSignedIn() const { return !accessToken.isEmpty(); }
    QString getBusyMessage() const { return busyMessage; }

public slots:
    void getVideoUrl(const QString &id);
    void setAccount(const QString &user, const QString &aToken, const QString &rToken, int expiry);

private slots:
    void setUsername(const QString &user);
    void setAccessToken(const QString &token);
    void setRefreshToken(const QString &token, int expiry);
    void setTokenExpiry(int expiry);
    void refreshAccessToken(QString token = QString());
    void checkForToken();
    void parseVideoPage();
    void setBusyMessage(const QString &message);
    void clearBusyMessage();

private:
    QNetworkAccessManager *nam;
    QString clientId;
    QString clientSecret;
    QString accessToken;
    QString refreshToken;
    QTimer *refreshTimer;
    int tokenExpiry;
    QString username;
    QString busyMessage;

signals:
    void gotVideoUrl(const QString &videoUrl);
    void videoUrlError();
    void alert(const QString &message);
    void usernameChanged();
    void userSignedInChanged();
    void accessTokenChanged();
    void clientIdChanged();
    void clientSecretChanged();
    void refreshTokenChanged();
    void tokenExpiryChanged();
    void signedIn(const QString &user, const QString &aToken, const QString &rToken, int expiry);
    void busyMessageChanged();
};

#endif // DAILYMOTION_H
