import QtQuick 1.0
import "../images"

Item {
    id: root

    property string iconSource
    property alias label: label.text

    signal clicked
    signal pressed

    Image {
        id: icon

        anchors { left: parent.left; leftMargin: 10; verticalCenter: parent.verticalCenter }
        source: "../" + iconSource
    }

    Label {
        id: label

        anchors { left: icon.right; verticalCenter: parent.verticalCenter; right: parent.right; rightMargin: 10 }
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        font.pixelSize: _LARGE_FONT_SIZE
        color: mouseArea.pressed ? Settings.activeColor : _TEXT_COLOR
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
        onPressAndHold: parent.pressed()
    }
}
