import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    property Item profilePage: null
    property Item uploadsPage: null
    property Item favouritesPage: null
    property Item playlistsPage: null
    property Item subscriptionsPage: null

    function getUserProfile(user) {
        profilePage = tabGroup.addTab(Qt.resolvedUrl("YTUserProfilePage.qml"), 0);
        profilePage.tools = null;
        profilePage.getUserProfile(user);
    }

    function loadUploads() {
        uploadsPage = tabGroup.addTab(Qt.resolvedUrl("YTListPage.qml"), 1);
        uploadsPage.title = qsTr("Uploads");
        uploadsPage.enableSearch = true;
        uploadsPage.setVideoFeed("http://gdata.youtube.com/feeds/api/users/" + profilePage.username + "/uploads?v=2&alt=json&max-results=30");
    }

    function loadFavourites() {
        favouritesPage = tabGroup.addTab(Qt.resolvedUrl("YTListPage.qml"), 2);
        favouritesPage.title = qsTr("Favourites");
        favouritesPage.setVideoFeed("http://gdata.youtube.com/feeds/api/users/" + profilePage.username + "/favorites?v=2&alt=json&max-results=30");
    }

    function loadPlaylists() {
        playlistsPage = tabGroup.addTab(Qt.resolvedUrl("YTPlaylistsPage.qml"), 3);
        playlistsPage.setPlaylistFeed("http://gdata.youtube.com/feeds/api/users/" + profilePage.username + "/playlists?v=2&alt=json&max-results=30");
    }

    function loadSubscriptions() {
        subscriptionsPage = tabGroup.addTab(Qt.resolvedUrl("YTSubscriptionsPage.qml"), 4);
        subscriptionsPage.setSubscriptionsFeed("http://gdata.youtube.com/feeds/api/users/" + profilePage.username + "/subscriptions?v=2&alt=json&max-results=30");
    }

    title: tabGroup.currentTab === null ? "" : tabGroup.currentTab.title
    tools: tabGroup.currentTab === null ? null : tabGroup.currentTab.tools

    Connections {
        target: YouTube
        onSubscribed: {
            if (pageStack.currentPage == root) {
                profilePage.isSubscribed = true;
                messages.displayMessage(qsTr("You have subscribed to") + " '" + profilePage.username + "'");
            }
        }
        onUnsubscribed: {
            if (pageStack.currentPage == root) {
                profilePage.isSubscribed = false;
                messages.displayMessage(qsTr("You have unsubscribed to") + " '" + profilePage.username + "'");
            }
        }
    }

    TabGroup {
        id: tabGroup

        anchors { fill: parent; topMargin: titleArea.height + tabBar.height }
    }

    TabBar {
        id: tabBar

        anchors { left: parent.left; right: parent.right; top: parent.top; topMargin: titleArea.height }

        buttons: [
            TabButton {
                iconSource: checked ? "images/contact-" + Settings.activeColorString + ".png" : !theme.inverted ? "images/contact.png" : "images/contact-white.png"
                checked: tabGroup.currentTab == profilePage
                onClicked: tabGroup.setTab(0)
            },

            TabButton {
                iconSource: checked ? "images/transfer-upload-" + Settings.activeColorString + ".png" : !theme.inverted ? "images/transfer-upload.png" : "images/transfer-upload-white.png"
                checked: tabGroup.currentTab == uploadsPage
                onClicked: if (uploadsPage === null) loadUploads(); else tabGroup.setTab(1);
            },

            TabButton {
                iconSource: checked ? "images/favourite-" + Settings.activeColorString + ".png" : !theme.inverted ? "images/favourite.png" : "images/favourite-white.png"
                checked: tabGroup.currentTab == favouritesPage
                onClicked: if (favouritesPage === null) loadFavourites(); else tabGroup.setTab(2);
            },

            TabButton {
                iconSource: checked ? "images/list-" + Settings.activeColorString + ".png" : !theme.inverted ? "images/list.png" : "images/list-white.png"
                checked: tabGroup.currentTab == playlistsPage
                onClicked: if (playlistsPage === null) loadPlaylists(); else tabGroup.setTab(3);
            },

            TabButton {
                iconSource: checked ? "images/subscriptions-" + Settings.activeColorString + ".png" : !theme.inverted ? "images/subscriptions.png" : "images/subscriptions-white.png"
                checked: tabGroup.currentTab == subscriptionsPage
                onClicked: if (subscriptionsPage === null) loadSubscriptions(); else tabGroup.setTab(4);
            }
        ]
    }
}
