import QtQuick 1.0
import "components"

QueryDialog {
    id: root

    property string videoId

    signal metadataUpdated(variant metadata)

    function getVideoMetadata(id) {
        var request = new XMLHttpRequest();
        request.onreadystatechange = function() {
            if (request.readyState == XMLHttpRequest.DONE) {
                try {
                    var res = eval("(" + request.responseText + ")").entry;
                    videoId = res.media$group.yt$videoid.$t;
                    titleInput.text = res.title.$t;
                    descriptionInput.text = res.media$group.media$description.$t;
                    tagsInput.text = !res.media$group.media$keywords.$t ? "" : res.media$group.media$keywords.$t;
                    categorySelector.setInitialValue(res.category[1].term);
                    commentsSelector.setInitialValue(res.yt$accessControl[0].permission);
                    commentVoteCheckbox.checked = (res.yt$accessControl[1].permission == "allowed") ? true : false;
                    responsesSelector.setInitialValue(res.yt$accessControl[2].permission);
                    ratingsCheckbox.checked = (res.yt$accessControl[3].permission == "allowed") ? true : false;
                    embedCheckbox.checked = (res.yt$accessControl[4].permission == "allowed") ? true : false;
                    listCheckbox.checked = (res.yt$accessControl[5].permission == "allowed") ? true : false;
                    syndicationCheckbox.checked = (res.yt$accessControl[7].permission == "allowed") ? true : false;
                    if (res.media$group.yt$private) {
                        privateCheckbox.checked = true;
                    }
                    busyDialog.visible = false;
                }
                catch(err) {
                    busyDialog.visible = false;
                    messages.displayMessage(qsTr("Cannot retrieve video details"));
                }
            }
        }
        request.open("GET", "http://gdata.youtube.com/feeds/api/videos/" + id + "?v=2&alt=json");
        request.send();
    }

    function updateMetadata() {
        toggleBusy(true);
        var metadata = {};
        metadata["title"] = titleInput.text;
        metadata["description"] = descriptionInput.text;
        metadata["tags"] = tagsInput.text;
        metadata["category"] = categorySelector.currentValue;
        metadata["commentsPermission"] = commentsSelector.currentValue;
        metadata["responsePermission"] = responsesSelector.currentValue;
        metadata["commentVotePermission"] = (commentVoteCheckbox.checked) ? "allowed" : "denied";
        metadata["ratingsPermission"] = (ratingsCheckbox.checked) ? "allowed" : "denied";
        metadata["listPermission"] = (listCheckbox.checked) ? "allowed" : "denied";
        metadata["syndicationPermission"] = (syndicationCheckbox.checked) ? "allowed" : "denied";
        metadata["embedPermission"] = (embedCheckbox.checked) ? "allowed" : "denied";
        metadata["private"] = privateCheckbox.checked;
        YouTube.updateVideoMetadata(videoId, metadata);
        metadataUpdated(metadata);
    }

    titleText: qsTr("Edit metadata")
    onAccepted: updateMetadata()
    rejectButtonText: qsTr("Cancel")
    acceptButtonText: qsTr("Update")
    content: Item {
        anchors.fill: parent

        Flickable {
            id: flicker

            anchors.fill: parent
            contentWidth: width
            contentHeight: col1.height + 20
            flickableDirection: Flickable.VerticalFlick
            clip: true
            visible: !busyDialog.visible

            Column {
                id: col1

                anchors { top: parent.top; left: parent.left; right: parent.right }
                spacing: 20

                Label {
                    
                    font.bold: true
                    text: qsTr("Title")
                }

                TextField {
                    id: titleInput

                    width: parent.width
                }

                Label {
                    
                    font.bold: true
                    text: qsTr("Description")
                }

                TextArea {
                    id: descriptionInput

                    width: parent.width
                }

                Label {
                    
                    font.bold: true
                    text: qsTr("Tags (separated by commas)")
                }

                TextField {
                    id: tagsInput

                    width: parent.width
                }

                SelectionItem {
                    id: categorySelector

                    title: qsTr("Category")
                    model: ListModel {
                        ListElement { name: QT_TR_NOOP("Cars & Vehicles"); value: "Autos" }
                        ListElement { name: QT_TR_NOOP("Comedy"); value: "Comedy" }
                        ListElement { name: QT_TR_NOOP("Education"); value: "Education" }
                        ListElement { name: QT_TR_NOOP("Entertainment"); value: "Entertainment" }
                        ListElement { name: QT_TR_NOOP("Film"); value: "Film" }
                        ListElement { name: QT_TR_NOOP("Gaming"); value: "Games" }
                        ListElement { name: QT_TR_NOOP("Music"); value: "Music" }
                        ListElement { name: QT_TR_NOOP("News & Politics"); value: "News" }
                        ListElement { name: QT_TR_NOOP("Non-profits & Activism"); value: "Nonprofit" }
                        ListElement { name: QT_TR_NOOP("People"); value: "People" }
                        ListElement { name: QT_TR_NOOP("Pets & Animals"); value: "Animals" }
                        ListElement { name: QT_TR_NOOP("Science & Technology"); value: "Tech" }
                        ListElement { name: QT_TR_NOOP("Sport"); value: "Sports" }
                        ListElement { name: QT_TR_NOOP("Style"); value: "Howto" }
                        ListElement { name: QT_TR_NOOP("Travel & Events"); value: "Travel" }
                    }
                    isChild: true
                    onOpened: lowerOpacity()
                    onAccepted: raiseOpacity()
                    onClosed: root.close()
                }

                SelectionItem {
                    id: responsesSelector

                    title: qsTr("Allow video responses?")
                    model: ListModel {
                        ListElement { name: QT_TR_NOOP("Yes"); value: "allowed" }
                        ListElement { name: QT_TR_NOOP("No"); value: "denied" }
                        ListElement { name: QT_TR_NOOP("Moderate"); value: "moderated" }
                    }
                    isChild: true
                    onOpened: lowerOpacity()
                    onAccepted: raiseOpacity()
                    onClosed: root.close()
                }

                SelectionItem {
                    id: commentsSelector

                    title: qsTr("Allow comments?")
                    model: ListModel {
                        ListElement { name: QT_TR_NOOP("Yes"); value: "allowed" }
                        ListElement { name: QT_TR_NOOP("No"); value: "denied" }
                        ListElement { name: QT_TR_NOOP("Moderate"); value: "moderated" }
                    }
                    isChild: true
                    onOpened: lowerOpacity()
                    onAccepted: raiseOpacity()
                    onClosed: root.close()
                }

                CheckBox {
                    id: commentVoteCheckbox

                    text: qsTr("Allow voting on comments?")
                    enabled: commentsSelector.currentValue != "denied"
                    onEnabledChanged: if (!enabled) checked = false;
                }

                CheckBox {
                    id: ratingsCheckbox

                    text: qsTr("Allow ratings?")
                }

                CheckBox {
                    id: privateCheckbox

                    text: qsTr("Private?")
                }

                CheckBox {
                    id: listCheckbox

                    text: qsTr("Appear in listings?")
                    enabled: !privateCheckbox.checked
                    onEnabledChanged: if (!enabled) checked = false;
                }

                CheckBox {
                    id: syndicationCheckbox

                    text: qsTr("Syndicate to mobile devices etc?")
                    enabled: !privateCheckbox.checked
                    onEnabledChanged: if (!enabled) checked = false;
                }

                CheckBox {
                    id: embedCheckbox

                    text: qsTr("Allow embedding?")
                    enabled: !privateCheckbox.checked
                    onEnabledChanged: if (!enabled) checked = false;
                }
            }
        }

        BusyDialog {
            id: busyDialog

            anchors.centerIn: parent
        }
    }
}
