import QtQuick 1.0
import "components"

Item {
    id: delegate

    signal clicked
    signal pressAndHold

    width: parent.width
    height: 80

    ListHighlight {
        visible: mouseArea.pressed
    }

    Label {
        id: titleText

        anchors { left: parent.left; leftMargin: 10; right: parent.right; rightMargin: 10; verticalCenter: parent.verticalCenter }
        elide: Text.ElideRight
        text: username
        
        font.bold: true
        anchors.fill: parent
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
        onPressAndHold: parent.pressAndHold()
    }
}
