#include "youtube.h"
#include <QtNetwork/QNetworkRequest>
#include <QtNetwork/QNetworkReply>
#include <QString>
#include <QRegExp>
#include <QUrl>
#include <QMap>
#include <QStringList>

#define EXCLUDED_CHARS " \n\t#[]{}=+$&*()<>@|',/\":;?"

YouTube::YouTube(QObject *parent) :
    QObject(parent), developerKey("AI39si6x9O1gQ1Z_BJqo9j2n_SdVsHu1pk2uqvoI3tVq8d6alyc1og785IPCkbVY3Q5MFuyt-IFYerMYun0MnLdQX5mo2BueSw"), playbackFormat(18) {
    pbMap["360p"] = 34;
    pbMap["hq"] = 18;
}

YouTube::~YouTube() {
}

void YouTube ::setUsername(const QString &user) {
    username = user;
    emit usernameChanged();
}

void YouTube::setAccessToken(const QString &token) {
    accessToken = token;
    emit accessTokenChanged();
    emit userSignedInChanged();
}

void YouTube::getVideoUrl(const QString &videoId) {
    QString playerUrl = "http://www.youtube.com/get_video_info?&video_id=" + videoId + "&el=detailpage&ps=default&eurl=&gl=US&hl=en";
    QNetworkAccessManager *manager = new QNetworkAccessManager(this);
    QNetworkRequest request;
    request.setUrl(QUrl(playerUrl));
    connect(manager, SIGNAL(finished(QNetworkReply*)), this, SLOT(parseVideoPage(QNetworkReply*)));
    manager->get(request);
}

void YouTube::parseVideoPage(QNetworkReply *reply) {
    QNetworkAccessManager *manager = qobject_cast<QNetworkAccessManager*>(sender());

    QMap<int, QString> formats;
    QString response(QByteArray::fromPercentEncoding(reply->readAll()));
    if (!response.contains("fmt_stream_map=url=")) {
        emit alert(tr("Unable to retrieve video. Access may be restricted"));
        emit videoUrlError();
    }
    else {
        response = response.split("fmt_stream_map=url=").at(1);
        QStringList parts = response.split(QRegExp(",url=|&url="));
        QString part;
        QStringList keySplit;
        QString url;
        int key;
        for (int i = 0; i < parts.length(); i++) {
            part = parts[i];
            url = QByteArray::fromPercentEncoding(part.left(part.indexOf("c.youtube.com&") + 13).toAscii()).replace("%2C", ",");
            keySplit = part.split("&itag=");
            if (keySplit.size() > 1) {
                key = keySplit.at(1).split(QRegExp("[&,]")).first().toInt();
                formats[key] = url;
            }
        }
        QList<int> flist;
        flist << pbMap.value("360p") << pbMap.value("hq");
        QString videoUrl;
        int index = flist.indexOf(playbackFormat);
        while ((videoUrl == "") && index < flist.size()) {
            videoUrl = formats.value(flist.at(index), "");
            index++;
        }
        if (!videoUrl.startsWith("http")) {
            emit alert(tr("Unable to retrieve video. Access may be restricted"));
            emit videoUrlError();
        }
        else {
            emit gotVideoUrl(videoUrl);
        }
    }
    reply->deleteLater();
    manager->deleteLater();
}


